/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermRangeFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class ExistsFilterParser
implements FilterParser {
    public static final String NAME = "exists";

    @Inject
    public ExistsFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                fieldName = parser.text();
                continue;
            }
            if (!"_name".equals(currentFieldName)) continue;
            filterName = parser.text();
        }
        if (fieldName == null) {
            throw new QueryParsingException(parseContext.index(), "exists must be provided with a [field]");
        }
        Filter filter = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            filter = smartNameFieldMappers.mapper().rangeFilter(null, null, true, true);
        }
        if (filter == null) {
            filter = new TermRangeFilter(fieldName, null, null, true, true);
        }
        filter = parseContext.cacheFilter(filter, null);
        filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

