/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.FuzzyLikeThisQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class FuzzyLikeThisFieldQueryParser
implements QueryParser {
    public static final String NAME = "flt_field";

    @Inject
    public FuzzyLikeThisFieldQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "fuzzy_like_this_field", Strings.toCamelCase(NAME), "fuzzyLikeThisField"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        int maxNumTerms = 25;
        float boost = 1.0f;
        String likeText = null;
        float minSimilarity = 0.5f;
        int prefixLength = 0;
        boolean ignoreTF = false;
        Analyzer analyzer = null;
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String fieldName = parser.currentName();
        token = parser.nextToken();
        assert (token == XContentParser.Token.START_OBJECT);
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("like_text".equals(currentFieldName) || "likeText".equals(currentFieldName)) {
                likeText = parser.text();
                continue;
            }
            if ("max_query_terms".equals(currentFieldName) || "maxQueryTerms".equals(currentFieldName)) {
                maxNumTerms = parser.intValue();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("ignore_tf".equals(currentFieldName) || "ignoreTF".equals(currentFieldName)) {
                ignoreTF = parser.booleanValue();
                continue;
            }
            if ("min_similarity".equals(currentFieldName) || "minSimilarity".equals(currentFieldName)) {
                minSimilarity = parser.floatValue();
                continue;
            }
            if ("prefix_length".equals(currentFieldName) || "prefixLength".equals(currentFieldName)) {
                prefixLength = parser.intValue();
                continue;
            }
            if (!"analyzer".equals(currentFieldName)) continue;
            analyzer = parseContext.analysisService().analyzer(parser.text());
        }
        if (likeText == null) {
            throw new QueryParsingException(parseContext.index(), "fuzzy_like_This_field requires 'like_text' to be specified");
        }
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            fieldName = smartNameFieldMappers.mapper().names().indexName();
            if (analyzer == null) {
                analyzer = smartNameFieldMappers.mapper().searchAnalyzer();
            }
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        FuzzyLikeThisQuery query = new FuzzyLikeThisQuery(maxNumTerms, analyzer);
        query.addTerms(likeText, fieldName, minSimilarity, prefixLength);
        query.setBoost(boost);
        query.setIgnoreTF(ignoreTF);
        token = parser.nextToken();
        assert (token == XContentParser.Token.END_OBJECT);
        return QueryParsers.wrapSmartNameQuery((Query)query, smartNameFieldMappers, parseContext);
    }
}

