/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.geo.GeoBoundingBoxFilter;
import org.elasticsearch.index.search.geo.GeoHashUtils;

public class GeoBoundingBoxFilterParser
implements FilterParser {
    public static final String NAME = "geo_bbox";

    @Inject
    public GeoBoundingBoxFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoBbox", "geo_bounding_box", "geoBoundingBox"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String fieldName = null;
        GeoBoundingBoxFilter.Point topLeft = new GeoBoundingBoxFilter.Point();
        GeoBoundingBoxFilter.Point bottomRight = new GeoBoundingBoxFilter.Point();
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    GeoBoundingBoxFilter.Point point;
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        point = null;
                        if ("top_left".equals(currentFieldName) || "topLeft".equals(currentFieldName)) {
                            point = topLeft;
                        } else if ("bottom_right".equals(currentFieldName) || "bottomRight".equals(currentFieldName)) {
                            point = bottomRight;
                        }
                        if (point == null) continue;
                        token = parser.nextToken();
                        point.lon = parser.doubleValue();
                        token = parser.nextToken();
                        point.lat = parser.doubleValue();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        }
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        point = null;
                        if ("top_left".equals(currentFieldName) || "topLeft".equals(currentFieldName)) {
                            point = topLeft;
                        } else if ("bottom_right".equals(currentFieldName) || "bottomRight".equals(currentFieldName)) {
                            point = bottomRight;
                        }
                        if (point == null) continue;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if (currentFieldName.equals("lat")) {
                                point.lat = parser.doubleValue();
                                continue;
                            }
                            if (currentFieldName.equals("lon")) {
                                point.lon = parser.doubleValue();
                                continue;
                            }
                            if (!currentFieldName.equals("geohash")) continue;
                            double[] values = GeoHashUtils.decode(parser.text());
                            point.lat = values[0];
                            point.lon = values[1];
                        }
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if ("field".equals(currentFieldName)) {
                        fieldName = parser.text();
                        continue;
                    }
                    point = null;
                    if ("top_left".equals(currentFieldName) || "topLeft".equals(currentFieldName)) {
                        point = topLeft;
                    } else if ("bottom_right".equals(currentFieldName) || "bottomRight".equals(currentFieldName)) {
                        point = bottomRight;
                    }
                    if (point == null) continue;
                    String value = parser.text();
                    int comma = value.indexOf(44);
                    if (comma != -1) {
                        point.lat = Double.parseDouble(value.substring(0, comma).trim());
                        point.lon = Double.parseDouble(value.substring(comma + 1).trim());
                        continue;
                    }
                    double[] values = GeoHashUtils.decode(value);
                    point.lat = values[0];
                    point.lon = values[1];
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if (!"_cache_key".equals(currentFieldName) && !"_cacheKey".equals(currentFieldName)) continue;
            cacheKey = new CacheKeyFilter.Key(parser.text());
        }
        MapperService mapperService = parseContext.mapperService();
        FieldMapper mapper = mapperService.smartNameFieldMapper(fieldName);
        if (mapper == null) {
            throw new QueryParsingException(parseContext.index(), "failed to find geo_point field [" + fieldName + "]");
        }
        if (mapper.fieldDataType() != GeoPointFieldDataType.TYPE) {
            throw new QueryParsingException(parseContext.index(), "field [" + fieldName + "] is not a geo_point field");
        }
        fieldName = mapper.names().indexName();
        GeoBoundingBoxFilter filter = new GeoBoundingBoxFilter(topLeft, bottomRight, fieldName, parseContext.indexCache().fieldData());
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, parseContext.smartFieldMappers(fieldName), parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

