/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class RangeQueryParser
implements QueryParser {
    public static final String NAME = "range";

    @Inject
    public RangeQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String fieldName = parser.currentName();
        String from = null;
        String to = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("from".equals(currentFieldName)) {
                from = parser.textOrNull();
                continue;
            }
            if ("to".equals(currentFieldName)) {
                to = parser.textOrNull();
                continue;
            }
            if ("include_lower".equals(currentFieldName) || "includeLower".equals(currentFieldName)) {
                includeLower = parser.booleanValue();
                continue;
            }
            if ("include_upper".equals(currentFieldName) || "includeUpper".equals(currentFieldName)) {
                includeUpper = parser.booleanValue();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("gt".equals(currentFieldName)) {
                from = parser.textOrNull();
                includeLower = false;
                continue;
            }
            if ("gte".equals(currentFieldName) || "ge".equals(currentFieldName)) {
                from = parser.textOrNull();
                includeLower = true;
                continue;
            }
            if ("lt".equals(currentFieldName)) {
                to = parser.textOrNull();
                includeUpper = false;
                continue;
            }
            if (!"lte".equals(currentFieldName) && !"le".equals(currentFieldName)) continue;
            to = parser.textOrNull();
            includeUpper = true;
        }
        token = parser.nextToken();
        assert (token == XContentParser.Token.END_OBJECT);
        Query query = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            query = smartNameFieldMappers.mapper().rangeQuery(from, to, includeLower, includeUpper);
        }
        if (query == null) {
            query = new TermRangeQuery(fieldName, from, to, includeLower, includeUpper);
        }
        query.setBoost(boost);
        return QueryParsers.wrapSmartNameQuery(query, smartNameFieldMappers, parseContext);
    }
}

