/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanTermQueryBuilder
extends BaseQueryBuilder
implements SpanQueryBuilder {
    private final String name;
    private final Object value;
    private float boost = -1.0f;

    public SpanTermQueryBuilder(String name, String value) {
        this(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, int value) {
        this(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, long value) {
        this(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, float value) {
        this(name, Float.valueOf(value));
    }

    public SpanTermQueryBuilder(String name, double value) {
        this(name, (Object)value);
    }

    private SpanTermQueryBuilder(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public SpanTermQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("span_term");
        if (this.boost == -1.0f) {
            builder.field(this.name, this.value);
        } else {
            builder.startObject(this.name);
            builder.field("value", this.value);
            builder.field("boost", this.boost);
            builder.endObject();
        }
        builder.endObject();
    }
}

