/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.util.OpenBitSet;

public class NonNestedDocsFilter
extends Filter {
    public static final NonNestedDocsFilter INSTANCE = new NonNestedDocsFilter();
    private final PrefixFilter filter = new PrefixFilter(new Term("_type", "__"));
    private final int hashCode = this.filter.hashCode();

    private NonNestedDocsFilter() {
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocIdSet docSet = this.filter.getDocIdSet(reader);
        if (docSet == null || docSet == DocIdSet.EMPTY_DOCIDSET) {
            docSet = new OpenBitSet((long)reader.maxDoc());
        }
        ((OpenBitSet)docSet).flip(0L, (long)reader.maxDoc());
        return docSet;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj == INSTANCE;
    }
}

