/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard.service;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastByteArrayOutputStream;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadSafe;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.recovery.RecoveryStatus;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.OperationListener;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.threadpool.ThreadPool;

@ThreadSafe
public class InternalIndexShard
extends AbstractIndexShardComponent
implements IndexShard {
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexCache indexCache;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final Store store;
    private final MergeSchedulerProvider mergeScheduler;
    private final Engine engine;
    private final Translog translog;
    private final IndexAliasesService indexAliasesService;
    private final Object mutex = new Object();
    private final boolean checkIndex;
    private volatile IndexShardState state;
    private TimeValue refreshInterval;
    private final TimeValue mergeInterval;
    private volatile ScheduledFuture refreshScheduledFuture;
    private volatile ScheduledFuture mergeScheduleFuture;
    private volatile ShardRouting shardRouting;
    private RecoveryStatus peerRecoveryStatus;
    private CopyOnWriteArrayList<OperationListener> listeners = null;
    private ApplyRefreshSettings applyRefreshSettings = new ApplyRefreshSettings();
    private final AtomicLong totalRefresh = new AtomicLong();
    private final AtomicLong totalRefreshTime = new AtomicLong();

    @Inject
    public InternalIndexShard(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, IndicesLifecycle indicesLifecycle, Store store, Engine engine, MergeSchedulerProvider mergeScheduler, Translog translog, ThreadPool threadPool, MapperService mapperService, IndexQueryParserService queryParserService, IndexCache indexCache, IndexAliasesService indexAliasesService) {
        super(shardId, indexSettings);
        this.indicesLifecycle = (InternalIndicesLifecycle)indicesLifecycle;
        this.indexSettingsService = indexSettingsService;
        this.store = store;
        this.engine = engine;
        this.mergeScheduler = mergeScheduler;
        this.translog = translog;
        this.threadPool = threadPool;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexCache = indexCache;
        this.indexAliasesService = indexAliasesService;
        this.state = IndexShardState.CREATED;
        this.refreshInterval = indexSettings.getAsTime("engine.robin.refresh_interval", indexSettings.getAsTime("index.refresh_interval", engine.defaultRefreshInterval()));
        this.mergeInterval = indexSettings.getAsTime("index.merge.async_interval", TimeValue.timeValueSeconds(1L));
        indexSettingsService.addListener(this.applyRefreshSettings);
        this.logger.debug("state: [CREATED]", new Object[0]);
        this.checkIndex = indexSettings.getAsBoolean("index.shard.check_index", false);
    }

    @Override
    public synchronized void addListener(OperationListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(OperationListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public MergeSchedulerProvider mergeScheduler() {
        return this.mergeScheduler;
    }

    public Store store() {
        return this.store;
    }

    public Engine engine() {
        return this.engine;
    }

    public Translog translog() {
        return this.translog;
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    public InternalIndexShard routingEntry(ShardRouting shardRouting) {
        if (!shardRouting.shardId().equals(this.shardId())) {
            throw new ElasticSearchIllegalArgumentException("Trying to set a routing entry with shardId [" + shardRouting.shardId() + "] on a shard with shardId [" + this.shardId() + "]");
        }
        if (this.shardRouting != null && !shardRouting.primary() && this.shardRouting.primary()) {
            this.logger.warn("suspect illegal state: trying to move shard from primary mode to backup mode", new Object[0]);
        }
        this.shardRouting = shardRouting;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState recovering(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            IndexShardState returnValue = this.state;
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.RECOVERING, reason});
            this.state = IndexShardState.RECOVERING;
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexShard relocated(String reason) throws IndexShardNotStartedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.STARTED) {
                throw new IndexShardNotStartedException(this.shardId, this.state);
            }
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.RELOCATED, reason});
            this.state = IndexShardState.RELOCATED;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexShard start(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (this.checkIndex) {
                this.checkIndex(true);
            }
            this.engine.start();
            this.startScheduledTasksIfNeeded();
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.STARTED, reason});
            this.state = IndexShardState.STARTED;
        }
        this.indicesLifecycle.afterIndexShardStarted(this);
        return this;
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    @Override
    public Engine.Create prepareCreate(SourceToParse source) throws ElasticSearchException {
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(source.type());
        ParsedDocument doc = docMapper.parse(source);
        return new Engine.Create(docMapper, docMapper.uidMapper().term(doc.uid()), doc);
    }

    @Override
    public ParsedDocument create(Engine.Create create) throws ElasticSearchException {
        this.writeAllowed();
        if (this.listeners != null) {
            for (OperationListener listener : this.listeners) {
                create = listener.beforeCreate(create);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index {}", create.docs());
        }
        this.engine.create(create);
        return create.parsedDoc();
    }

    @Override
    public Engine.Index prepareIndex(SourceToParse source) throws ElasticSearchException {
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(source.type());
        ParsedDocument doc = docMapper.parse(source);
        return new Engine.Index(docMapper, docMapper.uidMapper().term(doc.uid()), doc);
    }

    @Override
    public ParsedDocument index(Engine.Index index) throws ElasticSearchException {
        this.writeAllowed();
        if (this.listeners != null) {
            for (OperationListener listener : this.listeners) {
                index = listener.beforeIndex(index);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index {}", index.docs());
        }
        this.engine.index(index);
        return index.parsedDoc();
    }

    @Override
    public Engine.Delete prepareDelete(String type, String id, long version) throws ElasticSearchException {
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(type);
        return new Engine.Delete(type, id, docMapper.uidMapper().term(type, id)).version(version);
    }

    @Override
    public void delete(Engine.Delete delete) throws ElasticSearchException {
        this.writeAllowed();
        if (this.listeners != null) {
            for (OperationListener listener : this.listeners) {
                delete = listener.beforeDelete(delete);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("delete [{}]", delete.uid().text());
        }
        this.engine.delete(delete);
    }

    @Override
    public void deleteByQuery(byte[] querySource, @Nullable String[] filteringAliases, String ... types) throws ElasticSearchException {
        this.writeAllowed();
        if (types == null) {
            types = Strings.EMPTY_ARRAY;
        }
        this.innerDeleteByQuery(querySource, filteringAliases, types);
    }

    private void innerDeleteByQuery(byte[] querySource, String[] filteringAliases, String ... types) {
        Query query = this.queryParserService.parse(querySource).query();
        query = this.filterQueryIfNeeded(query, types);
        Filter aliasFilter = this.indexAliasesService.aliasFilter(filteringAliases);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("delete_by_query [{}]", query);
        }
        this.engine.delete(new Engine.DeleteByQuery(query, querySource, filteringAliases, aliasFilter, types));
    }

    @Override
    public Engine.GetResult get(Engine.Get get) throws ElasticSearchException {
        this.readAllowed();
        return this.engine.get(get);
    }

    @Override
    public long count(float minScore, byte[] querySource, @Nullable String[] filteringAliases, String ... types) throws ElasticSearchException {
        return this.count(minScore, querySource, 0, querySource.length, filteringAliases, types);
    }

    @Override
    public long count(float minScore, byte[] querySource, int querySourceOffset, int querySourceLength, @Nullable String[] filteringAliases, String ... types) throws ElasticSearchException {
        this.readAllowed();
        Query query = this.queryParserService.parse(querySource, querySourceOffset, querySourceLength).query();
        query = this.filterQueryIfNeeded(query, types);
        Filter aliasFilter = this.indexAliasesService.aliasFilter(filteringAliases);
        Engine.Searcher searcher = this.engine.searcher();
        try {
            long count = Lucene.count(searcher.searcher(), query, aliasFilter, minScore);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("count of [{}] is [{}]", query, count);
            }
            long l = count;
            return l;
        }
        catch (IOException e) {
            throw new ElasticSearchException("Failed to count query [" + query + "]", e);
        }
        finally {
            searcher.release();
        }
    }

    @Override
    public void refresh(Engine.Refresh refresh) throws ElasticSearchException {
        this.writeAllowed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with {}", refresh);
        }
        long time = System.currentTimeMillis();
        this.engine.refresh(refresh);
        this.totalRefresh.incrementAndGet();
        this.totalRefreshTime.addAndGet(System.currentTimeMillis() - time);
    }

    @Override
    public RefreshStats refreshStats() {
        return new RefreshStats(this.totalRefresh.get(), this.totalRefreshTime.get());
    }

    @Override
    public void flush(Engine.Flush flush) throws ElasticSearchException {
        this.writeAllowed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("flush with {}", flush);
        }
        this.engine.flush(flush);
    }

    @Override
    public void optimize(Engine.Optimize optimize) throws ElasticSearchException {
        this.writeAllowed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("optimize with {}", optimize);
        }
        this.engine.optimize(optimize);
    }

    @Override
    public <T> T snapshot(Engine.SnapshotHandler<T> snapshotHandler) throws EngineException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED && state != IndexShardState.RELOCATED && state != IndexShardState.CLOSED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed");
        }
        return this.engine.snapshot(snapshotHandler);
    }

    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        this.writeAllowed();
        this.engine.recover(recoveryHandler);
    }

    @Override
    public Engine.Searcher searcher() {
        this.readAllowed();
        return this.engine.searcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.clear();
            }
            this.listeners = null;
            this.indexSettingsService.removeListener(this.applyRefreshSettings);
            if (this.state != IndexShardState.CLOSED) {
                if (this.refreshScheduledFuture != null) {
                    this.refreshScheduledFuture.cancel(true);
                    this.refreshScheduledFuture = null;
                }
                if (this.mergeScheduleFuture != null) {
                    this.mergeScheduleFuture.cancel(true);
                    this.mergeScheduleFuture = null;
                }
            }
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.CLOSED, reason});
            this.state = IndexShardState.CLOSED;
        }
    }

    public void performRecoveryPrepareForTranslog() throws ElasticSearchException {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        if (this.checkIndex) {
            this.checkIndex(true);
        }
        this.engine.start();
    }

    public RecoveryStatus peerRecoveryStatus() {
        return this.peerRecoveryStatus;
    }

    public void performRecoveryFinalization(boolean withFlush, RecoveryStatus peerRecoveryStatus) throws ElasticSearchException {
        this.performRecoveryFinalization(withFlush);
        this.peerRecoveryStatus = peerRecoveryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryFinalization(boolean withFlush) throws ElasticSearchException {
        if (withFlush) {
            this.engine.flush(new Engine.Flush());
        }
        this.translog.clearUnreferenced();
        this.engine.refresh(new Engine.Refresh(true));
        Object object = this.mutex;
        synchronized (object) {
            this.logger.debug("state: [{}]->[{}], reason [post recovery]", new Object[]{this.state, IndexShardState.STARTED});
            this.state = IndexShardState.STARTED;
        }
        this.startScheduledTasksIfNeeded();
        this.indicesLifecycle.afterIndexShardStarted(this);
    }

    public void performRecoveryOperation(Translog.Operation operation) throws ElasticSearchException {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        switch (operation.opType()) {
            case CREATE: {
                Translog.Create create = (Translog.Create)operation;
                this.engine.create(this.prepareCreate(SourceToParse.source(create.source()).type(create.type()).id(create.id()).routing(create.routing()).parent(create.parent())).version(create.version()).origin(Engine.Operation.Origin.RECOVERY));
                break;
            }
            case SAVE: {
                Translog.Index index = (Translog.Index)operation;
                this.engine.index(this.prepareIndex(SourceToParse.source(index.source()).type(index.type()).id(index.id()).routing(index.routing()).parent(index.parent())).version(index.version()).origin(Engine.Operation.Origin.RECOVERY));
                break;
            }
            case DELETE: {
                Translog.Delete delete = (Translog.Delete)operation;
                Uid uid = Uid.createUid(delete.uid().text());
                this.engine.delete(new Engine.Delete(uid.type(), uid.id(), delete.uid()).version(delete.version()).origin(Engine.Operation.Origin.RECOVERY));
                break;
            }
            case DELETE_BY_QUERY: {
                Translog.DeleteByQuery deleteByQuery = (Translog.DeleteByQuery)operation;
                this.innerDeleteByQuery(deleteByQuery.source(), deleteByQuery.filteringAliases(), deleteByQuery.types());
                break;
            }
            default: {
                throw new ElasticSearchIllegalStateException("No operation defined for [" + operation + "]");
            }
        }
    }

    @Override
    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED && state != IndexShardState.RELOCATED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "Read operations only allowed when started/relocated");
        }
    }

    public void writeAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, state);
        }
    }

    private void startScheduledTasksIfNeeded() {
        if (this.refreshInterval.millis() > 0L) {
            this.refreshScheduledFuture = this.threadPool.schedule(this.refreshInterval, "same", new EngineRefresher());
            this.logger.debug("scheduling refresher every {}", this.refreshInterval);
        } else {
            this.logger.debug("scheduled refresher disabled", new Object[0]);
        }
        if (this.mergeInterval.millis() > 0L) {
            this.mergeScheduleFuture = this.threadPool.schedule(this.mergeInterval, "same", new EngineMerger());
            this.logger.debug("scheduling optimizer / merger every {}", this.mergeInterval);
        } else {
            this.logger.debug("scheduled optimizer / merger disabled", new Object[0]);
        }
    }

    private Query filterQueryIfNeeded(Query query, String[] types) {
        Filter searchFilter = this.mapperService.searchFilter(types);
        if (searchFilter != null) {
            query = new FilteredQuery(query, this.indexCache.filter().cache(searchFilter));
        }
        return query;
    }

    private void checkIndex(boolean throwException) throws IndexShardException {
        try {
            if (!IndexReader.indexExists((Directory)this.store.directory())) {
                return;
            }
            CheckIndex checkIndex = new CheckIndex(this.store.directory());
            FastByteArrayOutputStream os = new FastByteArrayOutputStream();
            PrintStream out = new PrintStream(os);
            checkIndex.setInfoStream(out);
            out.flush();
            CheckIndex.Status status = checkIndex.checkIndex();
            if (!status.clean) {
                if (this.state == IndexShardState.CLOSED) {
                    return;
                }
                this.logger.warn("check index [failure]\n{}", new String(os.unsafeByteArray(), 0, os.size()));
                if (throwException) {
                    throw new IndexShardException(this.shardId, "index check failure");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("check index [success]\n{}", new String(os.unsafeByteArray(), 0, os.size()));
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to check index", e, new Object[0]);
        }
    }

    static {
        IndexMetaData.addDynamicSettings("index.refresh_interval");
    }

    private class EngineMerger
    implements Runnable {
        private EngineMerger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!InternalIndexShard.this.engine().possibleMergeNeeded()) {
                Object object = InternalIndexShard.this.mutex;
                synchronized (object) {
                    if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                        InternalIndexShard.this.mergeScheduleFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.mergeInterval, "same", this);
                    }
                }
                return;
            }
            InternalIndexShard.this.threadPool.executor("merge").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        InternalIndexShard.this.engine.maybeMerge();
                    }
                    catch (EngineClosedException e) {
                    }
                    catch (OptimizeFailedEngineException e) {
                        if (!(e.getCause() instanceof EngineClosedException || e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException)) {
                            InternalIndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        InternalIndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                    }
                    Object object = InternalIndexShard.this.mutex;
                    synchronized (object) {
                        if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                            InternalIndexShard.this.mergeScheduleFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.mergeInterval, "same", EngineMerger.this);
                        }
                    }
                }
            });
        }
    }

    private class EngineRefresher
    implements Runnable {
        private EngineRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!InternalIndexShard.this.engine().refreshNeeded()) {
                Object object = InternalIndexShard.this.mutex;
                synchronized (object) {
                    if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                        InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.refreshInterval, "same", this);
                    }
                }
                return;
            }
            InternalIndexShard.this.threadPool.cached().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (InternalIndexShard.this.engine.refreshNeeded()) {
                            InternalIndexShard.this.refresh(new Engine.Refresh(false));
                        }
                    }
                    catch (EngineClosedException e) {
                    }
                    catch (RefreshFailedEngineException e) {
                        if (!(e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException)) {
                            InternalIndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        InternalIndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                    }
                    Object object = InternalIndexShard.this.mutex;
                    synchronized (object) {
                        if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                            InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.refreshInterval, "same", EngineRefresher.this);
                        }
                    }
                }
            });
        }
    }

    private class ApplyRefreshSettings
    implements IndexSettingsService.Listener {
        private ApplyRefreshSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            Object object = InternalIndexShard.this.mutex;
            synchronized (object) {
                if (InternalIndexShard.this.state == IndexShardState.CLOSED) {
                    return;
                }
                TimeValue refreshInterval = settings.getAsTime("engine.robin.refresh_interval", settings.getAsTime("index.refresh_interval", InternalIndexShard.this.refreshInterval));
                if (!refreshInterval.equals(InternalIndexShard.this.refreshInterval)) {
                    InternalIndexShard.this.logger.info("updating refresh_interval from [{}] to [{}]", InternalIndexShard.this.refreshInterval, refreshInterval);
                    if (InternalIndexShard.this.refreshScheduledFuture != null) {
                        InternalIndexShard.this.refreshScheduledFuture.cancel(false);
                        InternalIndexShard.this.refreshScheduledFuture = null;
                    }
                    InternalIndexShard.this.refreshInterval = refreshInterval;
                    if (refreshInterval.millis() > 0L) {
                        InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(refreshInterval, "same", new EngineRefresher());
                    }
                }
            }
        }
    }
}

