/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.ram;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.RAMFile;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.support.AbstractStore;

public class RamStore
extends AbstractStore {
    private final CustomRAMDirectory ramDirectory = new CustomRAMDirectory();
    private final Directory directory = this.wrapDirectory((Directory)this.ramDirectory);

    @Inject
    public RamStore(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore) throws IOException {
        super(shardId, indexSettings, indexStore);
        this.logger.debug("Using [ram] Store", new Object[0]);
    }

    @Override
    public Directory directory() {
        return this.directory;
    }

    @Override
    public boolean suggestUseCompoundFile() {
        return false;
    }

    @Override
    protected void doRenameFile(String from, String to) throws IOException {
        this.ramDirectory.renameTo(from, to);
    }

    static class CustomRAMDirectory
    extends RAMDirectory {
        CustomRAMDirectory() {
        }

        public synchronized void renameTo(String from, String to) throws IOException {
            RAMFile fromFile = (RAMFile)this.fileMap.get(from);
            if (fromFile == null) {
                throw new FileNotFoundException(from);
            }
            RAMFile toFile = (RAMFile)this.fileMap.get(to);
            if (toFile != null) {
                this.sizeInBytes.addAndGet(-this.fileLength(from));
                this.fileMap.remove(from);
            }
            this.fileMap.put(to, fromFile);
        }
    }
}

