/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.NotThreadSafe;
import org.elasticsearch.common.util.concurrent.ThreadSafe;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.translog.TranslogException;

@ThreadSafe
public interface Translog
extends IndexShardComponent {
    public static final String TRANSLOG_ID_KEY = "translog_id";

    public long currentId();

    public int estimatedNumberOfOperations();

    public long memorySizeInBytes();

    public long translogSizeInBytes();

    public void newTranslog(long var1) throws TranslogException;

    public void newTransientTranslog(long var1) throws TranslogException;

    public void makeTransientCurrent();

    public void revertTransient();

    public Location add(Operation var1) throws TranslogException;

    public byte[] read(Location var1);

    public Snapshot snapshot() throws TranslogException;

    public Snapshot snapshot(Snapshot var1);

    public void clearUnreferenced();

    public void sync();

    public void syncOnEachOperation(boolean var1);

    public void close(boolean var1);

    public static class DeleteByQuery
    implements Operation {
        private byte[] source;
        @Nullable
        private String[] filteringAliases;
        private String[] types = Strings.EMPTY_ARRAY;

        public DeleteByQuery() {
        }

        public DeleteByQuery(Engine.DeleteByQuery deleteByQuery) {
            this(deleteByQuery.source(), deleteByQuery.filteringAliases(), deleteByQuery.types());
        }

        public DeleteByQuery(byte[] source, String[] filteringAliases, String ... types) {
            this.source = source;
            this.types = types == null ? Strings.EMPTY_ARRAY : types;
            this.filteringAliases = filteringAliases;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE_BY_QUERY;
        }

        @Override
        public long estimateSize() {
            return this.source.length + 8;
        }

        public byte[] source() {
            return this.source;
        }

        public String[] filteringAliases() {
            return this.filteringAliases;
        }

        public String[] types() {
            return this.types;
        }

        @Override
        public BytesHolder readSource(BytesStreamInput in) throws IOException {
            throw new ElasticSearchIllegalStateException("trying to read doc source from delete_by_query operation");
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int aliasesSize;
            int typesSize;
            int version = in.readVInt();
            this.source = new byte[in.readVInt()];
            in.readFully(this.source);
            if (version < 2 && in.readBoolean()) {
                in.readUTF();
            }
            if ((typesSize = in.readVInt()) > 0) {
                this.types = new String[typesSize];
                for (int i = 0; i < typesSize; ++i) {
                    this.types[i] = in.readUTF();
                }
            }
            if (version >= 1 && (aliasesSize = in.readVInt()) > 0) {
                this.filteringAliases = new String[aliasesSize];
                for (int i = 0; i < aliasesSize; ++i) {
                    this.filteringAliases[i] = in.readUTF();
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(2);
            out.writeVInt(this.source.length);
            out.writeBytes(this.source);
            out.writeVInt(this.types.length);
            for (String type : this.types) {
                out.writeUTF(type);
            }
            if (this.filteringAliases != null) {
                out.writeVInt(this.filteringAliases.length);
                for (String alias : this.filteringAliases) {
                    out.writeUTF(alias);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    public static class Delete
    implements Operation {
        private Term uid;
        private long version;

        public Delete() {
        }

        public Delete(Engine.Delete delete) {
            this(delete.uid());
            this.version = delete.version();
        }

        public Delete(Term uid) {
            this.uid = uid;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE;
        }

        @Override
        public long estimateSize() {
            return (this.uid.field().length() + this.uid.text().length()) * 2 + 20;
        }

        public Term uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        @Override
        public BytesHolder readSource(BytesStreamInput in) throws IOException {
            throw new ElasticSearchIllegalStateException("trying to read doc source from delete operation");
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.uid = new Term(in.readUTF(), in.readUTF());
            if (version >= 1) {
                this.version = in.readLong();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(1);
            out.writeUTF(this.uid.field());
            out.writeUTF(this.uid.text());
            out.writeLong(this.version);
        }
    }

    public static class Index
    implements Operation {
        private String id;
        private String type;
        private long version;
        private byte[] source;
        private String routing;
        private String parent;

        public Index() {
        }

        public Index(Engine.Index index) {
            this(index.type(), index.id(), index.source());
            this.routing = index.routing();
            this.parent = index.parent();
            this.version = index.version();
        }

        public Index(String type, String id, byte[] source) {
            this.type = type;
            this.id = id;
            this.source = source;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.SAVE;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length + 12;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public byte[] source() {
            return this.source;
        }

        public long version() {
            return this.version;
        }

        @Override
        public BytesHolder readSource(BytesStreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readUTF();
            this.type = in.readUTF();
            int length = in.readVInt();
            int offset = in.position();
            return new BytesHolder(in.underlyingBuffer(), offset, length);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readUTF();
            this.type = in.readUTF();
            this.source = new byte[in.readVInt()];
            in.readFully(this.source);
            if (version >= 1 && in.readBoolean()) {
                this.routing = in.readUTF();
            }
            if (version >= 2 && in.readBoolean()) {
                this.parent = in.readUTF();
            }
            if (version >= 3) {
                this.version = in.readLong();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(3);
            out.writeUTF(this.id);
            out.writeUTF(this.type);
            out.writeVInt(this.source.length);
            out.writeBytes(this.source);
            if (this.routing == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.routing);
            }
            if (this.parent == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.parent);
            }
            out.writeLong(this.version);
        }
    }

    public static class Create
    implements Operation {
        private String id;
        private String type;
        private byte[] source;
        private String routing;
        private String parent;
        private long version;

        public Create() {
        }

        public Create(Engine.Create create) {
            this(create.type(), create.id(), create.source());
            this.routing = create.routing();
            this.parent = create.parent();
            this.version = create.version();
        }

        public Create(String type, String id, byte[] source) {
            this.id = id;
            this.type = type;
            this.source = source;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.CREATE;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length + 12;
        }

        public String id() {
            return this.id;
        }

        public byte[] source() {
            return this.source;
        }

        public String type() {
            return this.type;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public long version() {
            return this.version;
        }

        @Override
        public BytesHolder readSource(BytesStreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readUTF();
            this.type = in.readUTF();
            int length = in.readVInt();
            int offset = in.position();
            return new BytesHolder(in.underlyingBuffer(), offset, length);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readUTF();
            this.type = in.readUTF();
            this.source = new byte[in.readVInt()];
            in.readFully(this.source);
            if (version >= 1 && in.readBoolean()) {
                this.routing = in.readUTF();
            }
            if (version >= 2 && in.readBoolean()) {
                this.parent = in.readUTF();
            }
            if (version >= 3) {
                this.version = in.readLong();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(3);
            out.writeUTF(this.id);
            out.writeUTF(this.type);
            out.writeVInt(this.source.length);
            out.writeBytes(this.source);
            if (this.routing == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.routing);
            }
            if (this.parent == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.parent);
            }
            out.writeLong(this.version);
        }
    }

    public static interface Operation
    extends Streamable {
        public Type opType();

        public long estimateSize();

        public BytesHolder readSource(BytesStreamInput var1) throws IOException;

        public static enum Type {
            CREATE(1),
            SAVE(2),
            DELETE(3),
            DELETE_BY_QUERY(4);

            private final byte id;

            private Type(byte id) {
                this.id = id;
            }

            public byte id() {
                return this.id;
            }

            public static Type fromId(byte id) {
                switch (id) {
                    case 1: {
                        return CREATE;
                    }
                    case 2: {
                        return SAVE;
                    }
                    case 3: {
                        return DELETE;
                    }
                    case 4: {
                        return DELETE_BY_QUERY;
                    }
                }
                throw new IllegalArgumentException("No type mapped for [" + id + "]");
            }
        }
    }

    @NotThreadSafe
    public static interface Snapshot
    extends Releasable {
        public long translogId();

        public long position();

        public long length();

        public int estimatedTotalOperations();

        public boolean hasNext();

        public Operation next();

        public void seekForward(long var1);

        public InputStream stream() throws IOException;

        public long lengthInBytes();
    }

    public static class Location {
        public final long translogId;
        public final long translogLocation;
        public final int size;

        public Location(long translogId, long translogLocation, int size) {
            this.translogId = translogId;
            this.translogLocation = translogLocation;
            this.size = size;
        }
    }
}

