/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.query;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.AndFilterParser;
import org.elasticsearch.index.query.BoolFilterParser;
import org.elasticsearch.index.query.BoolQueryParser;
import org.elasticsearch.index.query.BoostingQueryParser;
import org.elasticsearch.index.query.ConstantScoreQueryParser;
import org.elasticsearch.index.query.CustomBoostFactorQueryParser;
import org.elasticsearch.index.query.CustomFiltersScoreQueryParser;
import org.elasticsearch.index.query.CustomScoreQueryParser;
import org.elasticsearch.index.query.DisMaxQueryParser;
import org.elasticsearch.index.query.ExistsFilterParser;
import org.elasticsearch.index.query.FQueryFilterParser;
import org.elasticsearch.index.query.FieldQueryParser;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.FilteredQueryParser;
import org.elasticsearch.index.query.FuzzyLikeThisFieldQueryParser;
import org.elasticsearch.index.query.FuzzyLikeThisQueryParser;
import org.elasticsearch.index.query.FuzzyQueryParser;
import org.elasticsearch.index.query.GeoBoundingBoxFilterParser;
import org.elasticsearch.index.query.GeoDistanceFilterParser;
import org.elasticsearch.index.query.GeoDistanceRangeFilterParser;
import org.elasticsearch.index.query.GeoPolygonFilterParser;
import org.elasticsearch.index.query.HasChildFilterParser;
import org.elasticsearch.index.query.HasChildQueryParser;
import org.elasticsearch.index.query.IdsFilterParser;
import org.elasticsearch.index.query.IdsQueryParser;
import org.elasticsearch.index.query.LimitFilterParser;
import org.elasticsearch.index.query.MatchAllFilterParser;
import org.elasticsearch.index.query.MatchAllQueryParser;
import org.elasticsearch.index.query.MissingFilterParser;
import org.elasticsearch.index.query.MoreLikeThisFieldQueryParser;
import org.elasticsearch.index.query.MoreLikeThisQueryParser;
import org.elasticsearch.index.query.NestedFilterParser;
import org.elasticsearch.index.query.NestedQueryParser;
import org.elasticsearch.index.query.NotFilterParser;
import org.elasticsearch.index.query.NumericRangeFilterParser;
import org.elasticsearch.index.query.OrFilterParser;
import org.elasticsearch.index.query.PrefixFilterParser;
import org.elasticsearch.index.query.PrefixQueryParser;
import org.elasticsearch.index.query.QueryFilterParser;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryStringQueryParser;
import org.elasticsearch.index.query.RangeFilterParser;
import org.elasticsearch.index.query.RangeQueryParser;
import org.elasticsearch.index.query.ScriptFilterParser;
import org.elasticsearch.index.query.SpanFirstQueryParser;
import org.elasticsearch.index.query.SpanNearQueryParser;
import org.elasticsearch.index.query.SpanNotQueryParser;
import org.elasticsearch.index.query.SpanOrQueryParser;
import org.elasticsearch.index.query.SpanTermQueryParser;
import org.elasticsearch.index.query.TermFilterParser;
import org.elasticsearch.index.query.TermQueryParser;
import org.elasticsearch.index.query.TermsFilterParser;
import org.elasticsearch.index.query.TermsQueryParser;
import org.elasticsearch.index.query.TextQueryParser;
import org.elasticsearch.index.query.TopChildrenQueryParser;
import org.elasticsearch.index.query.TypeFilterParser;
import org.elasticsearch.index.query.WildcardQueryParser;
import org.elasticsearch.index.query.WrapperQueryParser;

public class IndicesQueriesRegistry {
    private ImmutableMap<String, QueryParser> queryParsers;
    private ImmutableMap<String, FilterParser> filterParsers;

    @Inject
    public IndicesQueriesRegistry(Settings settings) {
        HashMap<String, QueryParser> queryParsers = Maps.newHashMap();
        this.addQueryParser(queryParsers, new TextQueryParser());
        this.addQueryParser(queryParsers, new NestedQueryParser());
        this.addQueryParser(queryParsers, new HasChildQueryParser());
        this.addQueryParser(queryParsers, new TopChildrenQueryParser());
        this.addQueryParser(queryParsers, new DisMaxQueryParser());
        this.addQueryParser(queryParsers, new IdsQueryParser());
        this.addQueryParser(queryParsers, new MatchAllQueryParser());
        this.addQueryParser(queryParsers, new QueryStringQueryParser());
        this.addQueryParser(queryParsers, new BoostingQueryParser());
        this.addQueryParser(queryParsers, new BoolQueryParser(settings));
        this.addQueryParser(queryParsers, new TermQueryParser());
        this.addQueryParser(queryParsers, new TermsQueryParser());
        this.addQueryParser(queryParsers, new FuzzyQueryParser());
        this.addQueryParser(queryParsers, new FieldQueryParser());
        this.addQueryParser(queryParsers, new RangeQueryParser());
        this.addQueryParser(queryParsers, new PrefixQueryParser());
        this.addQueryParser(queryParsers, new WildcardQueryParser());
        this.addQueryParser(queryParsers, new FilteredQueryParser());
        this.addQueryParser(queryParsers, new ConstantScoreQueryParser());
        this.addQueryParser(queryParsers, new CustomBoostFactorQueryParser());
        this.addQueryParser(queryParsers, new CustomScoreQueryParser());
        this.addQueryParser(queryParsers, new CustomFiltersScoreQueryParser());
        this.addQueryParser(queryParsers, new SpanTermQueryParser());
        this.addQueryParser(queryParsers, new SpanNotQueryParser());
        this.addQueryParser(queryParsers, new SpanFirstQueryParser());
        this.addQueryParser(queryParsers, new SpanNearQueryParser());
        this.addQueryParser(queryParsers, new SpanOrQueryParser());
        this.addQueryParser(queryParsers, new MoreLikeThisQueryParser());
        this.addQueryParser(queryParsers, new MoreLikeThisFieldQueryParser());
        this.addQueryParser(queryParsers, new FuzzyLikeThisQueryParser());
        this.addQueryParser(queryParsers, new FuzzyLikeThisFieldQueryParser());
        this.addQueryParser(queryParsers, new WrapperQueryParser());
        this.queryParsers = ImmutableMap.copyOf(queryParsers);
        HashMap<String, FilterParser> filterParsers = Maps.newHashMap();
        this.addFilterParser(filterParsers, new HasChildFilterParser());
        this.addFilterParser(filterParsers, new NestedFilterParser());
        this.addFilterParser(filterParsers, new TypeFilterParser());
        this.addFilterParser(filterParsers, new IdsFilterParser());
        this.addFilterParser(filterParsers, new LimitFilterParser());
        this.addFilterParser(filterParsers, new TermFilterParser());
        this.addFilterParser(filterParsers, new TermsFilterParser());
        this.addFilterParser(filterParsers, new RangeFilterParser());
        this.addFilterParser(filterParsers, new NumericRangeFilterParser());
        this.addFilterParser(filterParsers, new PrefixFilterParser());
        this.addFilterParser(filterParsers, new ScriptFilterParser());
        this.addFilterParser(filterParsers, new GeoDistanceFilterParser());
        this.addFilterParser(filterParsers, new GeoDistanceRangeFilterParser());
        this.addFilterParser(filterParsers, new GeoBoundingBoxFilterParser());
        this.addFilterParser(filterParsers, new GeoPolygonFilterParser());
        this.addFilterParser(filterParsers, new QueryFilterParser());
        this.addFilterParser(filterParsers, new FQueryFilterParser());
        this.addFilterParser(filterParsers, new BoolFilterParser());
        this.addFilterParser(filterParsers, new AndFilterParser());
        this.addFilterParser(filterParsers, new OrFilterParser());
        this.addFilterParser(filterParsers, new NotFilterParser());
        this.addFilterParser(filterParsers, new MatchAllFilterParser());
        this.addFilterParser(filterParsers, new ExistsFilterParser());
        this.addFilterParser(filterParsers, new MissingFilterParser());
        this.filterParsers = ImmutableMap.copyOf(filterParsers);
    }

    public void addQueryParser(QueryParser queryParser) {
        HashMap<String, QueryParser> queryParsers = Maps.newHashMap(this.queryParsers);
        this.addQueryParser(queryParsers, queryParser);
        this.queryParsers = ImmutableMap.copyOf(queryParsers);
    }

    public void addFilterParser(FilterParser filterParser) {
        HashMap<String, FilterParser> filterParsers = Maps.newHashMap(this.filterParsers);
        this.addFilterParser(filterParsers, filterParser);
        this.filterParsers = ImmutableMap.copyOf(filterParsers);
    }

    public ImmutableMap<String, QueryParser> queryParsers() {
        return this.queryParsers;
    }

    public ImmutableMap<String, FilterParser> filterParsers() {
        return this.filterParsers;
    }

    private void addQueryParser(Map<String, QueryParser> queryParsers, QueryParser queryParser) {
        for (String name : queryParser.names()) {
            queryParsers.put(name, queryParser);
        }
    }

    private void addFilterParser(Map<String, FilterParser> filterParsers, FilterParser filterParser) {
        for (String name : filterParser.names()) {
            filterParsers.put(name, filterParser);
        }
    }
}

