/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.state;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationExplanation;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestClusterStateAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestClusterStateAction(Settings settings, Client client, RestController controller, SettingsFilter settingsFilter) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        final ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest();
        clusterStateRequest.filterNodes(request.paramAsBoolean("filter_nodes", clusterStateRequest.filterNodes()));
        clusterStateRequest.filterRoutingTable(request.paramAsBoolean("filter_routing_table", clusterStateRequest.filterRoutingTable()));
        clusterStateRequest.filterMetaData(request.paramAsBoolean("filter_metadata", clusterStateRequest.filterMetaData()));
        clusterStateRequest.filterBlocks(request.paramAsBoolean("filter_blocks", clusterStateRequest.filterBlocks()));
        clusterStateRequest.filteredIndices(RestActions.splitIndices(request.param("filter_indices", null)));
        clusterStateRequest.filteredIndexTemplates(request.paramAsStringArray("filter_index_templates", Strings.EMPTY_ARRAY));
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        this.client.admin().cluster().state(clusterStateRequest, new ActionListener<ClusterStateResponse>(){

            @Override
            public void onResponse(ClusterStateResponse response) {
                try {
                    ClusterState state = response.state();
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("cluster_name", response.clusterName().value());
                    if (!clusterStateRequest.filterNodes()) {
                        builder.field("master_node", state.nodes().masterNodeId());
                    }
                    if (!clusterStateRequest.filterBlocks()) {
                        builder.startObject("blocks");
                        if (!state.blocks().global().isEmpty()) {
                            builder.startObject("global");
                            for (ClusterBlock clusterBlock : state.blocks().global()) {
                                clusterBlock.toXContent(builder, request);
                            }
                            builder.endObject();
                        }
                        if (!state.blocks().indices().isEmpty()) {
                            builder.startObject("indices");
                            for (Map.Entry entry : state.blocks().indices().entrySet()) {
                                builder.startObject((String)entry.getKey());
                                for (ClusterBlock block : (ImmutableSet)entry.getValue()) {
                                    block.toXContent(builder, request);
                                }
                                builder.endObject();
                            }
                            builder.endObject();
                        }
                        builder.endObject();
                    }
                    if (!clusterStateRequest.filterNodes()) {
                        builder.startObject("nodes");
                        for (DiscoveryNode discoveryNode : state.nodes()) {
                            builder.startObject(discoveryNode.id(), XContentBuilder.FieldCaseConversion.NONE);
                            builder.field("name", discoveryNode.name());
                            builder.field("transport_address", discoveryNode.address().toString());
                            builder.startObject("attributes");
                            for (Map.Entry attr : discoveryNode.attributes().entrySet()) {
                                builder.field((String)attr.getKey(), (String)attr.getValue());
                            }
                            builder.endObject();
                            builder.endObject();
                        }
                        builder.endObject();
                    }
                    if (!clusterStateRequest.filterMetaData()) {
                        Map<String, Object> mapping;
                        XContentParser parser;
                        byte[] mappingSource;
                        Settings settings;
                        builder.startObject("metadata");
                        builder.startObject("templates");
                        for (IndexTemplateMetaData indexTemplateMetaData : state.metaData().templates().values()) {
                            builder.startObject(indexTemplateMetaData.name(), XContentBuilder.FieldCaseConversion.NONE);
                            builder.field("template", indexTemplateMetaData.template());
                            builder.field("order", indexTemplateMetaData.order());
                            builder.startObject("settings");
                            settings = RestClusterStateAction.this.settingsFilter.filterSettings(indexTemplateMetaData.settings());
                            for (Map.Entry entry : settings.getAsMap().entrySet()) {
                                builder.field((String)entry.getKey(), (String)entry.getValue());
                            }
                            builder.endObject();
                            builder.startObject("mappings");
                            for (Map.Entry entry : indexTemplateMetaData.mappings().entrySet()) {
                                mappingSource = ((CompressedString)entry.getValue()).uncompressed();
                                parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                                mapping = parser.map();
                                if (mapping.size() == 1 && mapping.containsKey(entry.getKey())) {
                                    mapping = (Map<String, Object>)mapping.get(entry.getKey());
                                }
                                builder.field((String)entry.getKey());
                                builder.map(mapping);
                            }
                            builder.endObject();
                            builder.endObject();
                        }
                        builder.endObject();
                        builder.startObject("indices");
                        for (IndexMetaData indexMetaData : state.metaData()) {
                            builder.startObject(indexMetaData.index(), XContentBuilder.FieldCaseConversion.NONE);
                            builder.field("state", indexMetaData.state().toString().toLowerCase());
                            builder.startObject("settings");
                            settings = RestClusterStateAction.this.settingsFilter.filterSettings(indexMetaData.settings());
                            for (Map.Entry entry : settings.getAsMap().entrySet()) {
                                builder.field((String)entry.getKey(), (String)entry.getValue());
                            }
                            builder.endObject();
                            builder.startObject("mappings");
                            for (Map.Entry entry : indexMetaData.mappings().entrySet()) {
                                mappingSource = ((MappingMetaData)entry.getValue()).source().uncompressed();
                                parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                                mapping = parser.map();
                                if (mapping.size() == 1 && mapping.containsKey(entry.getKey())) {
                                    mapping = (Map)mapping.get(entry.getKey());
                                }
                                builder.field((String)entry.getKey());
                                builder.map(mapping);
                            }
                            builder.endObject();
                            builder.startArray("aliases");
                            for (String alias : indexMetaData.aliases().keySet()) {
                                builder.value(alias);
                            }
                            builder.endArray();
                            builder.endObject();
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    if (!clusterStateRequest.filterRoutingTable()) {
                        builder.startObject("routing_table");
                        builder.startObject("indices");
                        for (IndexRoutingTable indexRoutingTable : state.routingTable()) {
                            builder.startObject(indexRoutingTable.index(), XContentBuilder.FieldCaseConversion.NONE);
                            builder.startObject("shards");
                            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                                builder.startArray(Integer.toString(indexShardRoutingTable.shardId().id()));
                                for (ShardRouting shardRouting : indexShardRoutingTable) {
                                    this.jsonShardRouting(builder, shardRouting);
                                }
                                builder.endArray();
                            }
                            builder.endObject();
                            builder.endObject();
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    if (!clusterStateRequest.filterRoutingTable()) {
                        builder.startObject("routing_nodes");
                        builder.startArray("unassigned");
                        for (MutableShardRouting mutableShardRouting : state.readOnlyRoutingNodes().unassigned()) {
                            this.jsonShardRouting(builder, mutableShardRouting);
                        }
                        builder.endArray();
                        builder.startObject("nodes");
                        for (RoutingNode routingNode : state.readOnlyRoutingNodes()) {
                            builder.startArray(routingNode.nodeId(), XContentBuilder.FieldCaseConversion.NONE);
                            for (MutableShardRouting shardRouting : routingNode) {
                                this.jsonShardRouting(builder, shardRouting);
                            }
                            builder.endArray();
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    if (!clusterStateRequest.filterRoutingTable()) {
                        builder.startArray("allocations");
                        for (Map.Entry entry : state.allocationExplanation().explanations().entrySet()) {
                            builder.startObject();
                            builder.field("index", ((ShardId)entry.getKey()).index().name());
                            builder.field("shard", ((ShardId)entry.getKey()).id());
                            builder.startArray("explanations");
                            for (AllocationExplanation.NodeExplanation nodeExplanation : (List)entry.getValue()) {
                                builder.field("desc", nodeExplanation.description());
                                if (nodeExplanation.node() == null) continue;
                                builder.startObject("node");
                                builder.field("id", nodeExplanation.node().id());
                                builder.field("name", nodeExplanation.node().name());
                                builder.endObject();
                            }
                            builder.endArray();
                            builder.endObject();
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            private void jsonShardRouting(XContentBuilder builder, ShardRouting shardRouting) throws IOException {
                builder.startObject().field("state", (Object)shardRouting.state()).field("primary", shardRouting.primary()).field("node", shardRouting.currentNodeId()).field("relocating_node", shardRouting.relocatingNodeId()).field("shard", shardRouting.shardId().id()).field("index", shardRouting.shardId().index().name()).endObject();
            }

            @Override
            public void onFailure(Throwable e) {
                if (RestClusterStateAction.this.logger.isDebugEnabled()) {
                    RestClusterStateAction.this.logger.debug("failed to handle cluster state", e, new Object[0]);
                }
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestClusterStateAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

