/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.trove.iterator.TObjectFloatIterator;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class SearchSourceBuilder
implements ToXContent {
    private QueryBuilder queryBuilder;
    private byte[] queryBinary;
    private FilterBuilder filterBuilder;
    private byte[] filterBinary;
    private int from = -1;
    private int size = -1;
    private Boolean explain;
    private Boolean version;
    private List<SortBuilder> sorts;
    private boolean trackScores = false;
    private Float minScore;
    private List<String> fieldNames;
    private List<ScriptField> scriptFields;
    private List<AbstractFacetBuilder> facets;
    private byte[] facetsBinary;
    private HighlightBuilder highlightBuilder;
    private TObjectFloatHashMap<String> indexBoost = null;

    public static SearchSourceBuilder searchSource() {
        return new SearchSourceBuilder();
    }

    public static HighlightBuilder highlight() {
        return new HighlightBuilder();
    }

    public SearchSourceBuilder query(QueryBuilder query) {
        this.queryBuilder = query;
        return this;
    }

    public SearchSourceBuilder query(byte[] queryBinary) {
        this.queryBinary = queryBinary;
        return this;
    }

    public SearchSourceBuilder query(String queryString) {
        this.queryBinary = Unicode.fromStringAsBytes(queryString);
        return this;
    }

    public SearchSourceBuilder filter(FilterBuilder filter) {
        this.filterBuilder = filter;
        return this;
    }

    public SearchSourceBuilder filter(String filterString) {
        this.filterBinary = Unicode.fromStringAsBytes(filterString);
        return this;
    }

    public SearchSourceBuilder filter(byte[] filter) {
        this.filterBinary = filter;
        return this;
    }

    public SearchSourceBuilder from(int from) {
        this.from = from;
        return this;
    }

    public SearchSourceBuilder size(int size) {
        this.size = size;
        return this;
    }

    public SearchSourceBuilder minScore(float minScore) {
        this.minScore = Float.valueOf(minScore);
        return this;
    }

    public SearchSourceBuilder explain(Boolean explain) {
        this.explain = explain;
        return this;
    }

    public SearchSourceBuilder version(Boolean version) {
        this.version = version;
        return this;
    }

    public SearchSourceBuilder sort(String name, SortOrder order) {
        return this.sort(SortBuilders.fieldSort(name).order(order));
    }

    public SearchSourceBuilder sort(String name) {
        return this.sort(SortBuilders.fieldSort(name));
    }

    public SearchSourceBuilder sort(SortBuilder sort) {
        if (this.sorts == null) {
            this.sorts = Lists.newArrayList();
        }
        this.sorts.add(sort);
        return this;
    }

    public SearchSourceBuilder trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public SearchSourceBuilder facet(AbstractFacetBuilder facet) {
        if (this.facets == null) {
            this.facets = Lists.newArrayList();
        }
        this.facets.add(facet);
        return this;
    }

    public SearchSourceBuilder facets(byte[] facetsBinary) {
        this.facetsBinary = facetsBinary;
        return this;
    }

    public HighlightBuilder highlighter() {
        if (this.highlightBuilder == null) {
            this.highlightBuilder = new HighlightBuilder();
        }
        return this.highlightBuilder;
    }

    public SearchSourceBuilder highlight(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public SearchSourceBuilder noFields() {
        this.fieldNames = ImmutableList.of();
        return this;
    }

    public SearchSourceBuilder fields(List<String> fields) {
        this.fieldNames = fields;
        return this;
    }

    public SearchSourceBuilder fields(String ... fields) {
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList<String>();
        }
        for (String field : fields) {
            this.fieldNames.add(field);
        }
        return this;
    }

    public SearchSourceBuilder field(String name) {
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList<String>();
        }
        this.fieldNames.add(name);
        return this;
    }

    public SearchSourceBuilder scriptField(String name, String script) {
        return this.scriptField(name, null, script, null);
    }

    public SearchSourceBuilder scriptField(String name, String script, Map<String, Object> params) {
        return this.scriptField(name, null, script, params);
    }

    public SearchSourceBuilder scriptField(String name, String lang, String script, Map<String, Object> params) {
        if (this.scriptFields == null) {
            this.scriptFields = Lists.newArrayList();
        }
        this.scriptFields.add(new ScriptField(name, lang, script, params));
        return this;
    }

    public SearchSourceBuilder indexBoost(String index, float indexBoost) {
        if (this.indexBoost == null) {
            this.indexBoost = new TObjectFloatHashMap();
        }
        this.indexBoost.put(index, indexBoost);
        return this;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON).prettyPrint();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.string();
        }
        catch (Exception e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    public BytesStream buildAsUnsafeBytes(XContentType contentType) throws SearchSourceBuilderException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return builder.unsafeStream();
        }
        catch (Exception e) {
            throw new SearchSourceBuilderException("Failed to build search source", e);
        }
    }

    public byte[] buildAsBytes() throws SearchSourceBuilderException {
        return this.buildAsBytes(Requests.CONTENT_TYPE);
    }

    public byte[] buildAsBytes(XContentType contentType) throws SearchSourceBuilderException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            this.toXContent(builder, EMPTY_PARAMS);
            return builder.copiedBytes();
        }
        catch (Exception e) {
            throw new SearchSourceBuilderException("Failed to build search source", e);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.from != -1) {
            builder.field("from", this.from);
        }
        if (this.size != -1) {
            builder.field("size", this.size);
        }
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        }
        if (this.queryBinary != null) {
            if (XContentFactory.xContentType(this.queryBinary) == builder.contentType()) {
                builder.rawField("query", this.queryBinary);
            } else {
                builder.field("query_binary", this.queryBinary);
            }
        }
        if (this.filterBuilder != null) {
            builder.field("filter");
            this.filterBuilder.toXContent(builder, params);
        }
        if (this.filterBinary != null) {
            if (XContentFactory.xContentType(this.queryBinary) == builder.contentType()) {
                builder.rawField("filter", this.filterBinary);
            } else {
                builder.field("filter_binary", this.queryBinary);
            }
        }
        if (this.minScore != null) {
            builder.field("min_score", this.minScore);
        }
        if (this.version != null) {
            builder.field("version", (Object)this.version);
        }
        if (this.explain != null) {
            builder.field("explain", (Object)this.explain);
        }
        if (this.fieldNames != null) {
            if (this.fieldNames.size() == 1) {
                builder.field("fields", this.fieldNames.get(0));
            } else {
                builder.startArray("fields");
                for (String fieldName : this.fieldNames) {
                    builder.value(fieldName);
                }
                builder.endArray();
            }
        }
        if (this.scriptFields != null) {
            builder.startObject("script_fields");
            for (ScriptField scriptField : this.scriptFields) {
                builder.startObject(scriptField.fieldName());
                builder.field("script", scriptField.script());
                if (scriptField.lang() != null) {
                    builder.field("lang", scriptField.lang());
                }
                if (scriptField.params() != null) {
                    builder.field("params");
                    builder.map(scriptField.params());
                }
                builder.endObject();
            }
            builder.endObject();
        }
        if (this.sorts != null) {
            builder.startArray("sort");
            for (SortBuilder sort : this.sorts) {
                builder.startObject();
                sort.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            if (this.trackScores) {
                builder.field("track_scores", this.trackScores);
            }
        }
        if (this.indexBoost != null) {
            builder.startObject("indices_boost");
            TObjectFloatIterator<String> it = this.indexBoost.iterator();
            while (it.hasNext()) {
                it.advance();
                builder.field(it.key(), it.value());
            }
            builder.endObject();
        }
        if (this.facets != null) {
            builder.field("facets");
            builder.startObject();
            for (AbstractFacetBuilder facet : this.facets) {
                facet.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.facetsBinary != null) {
            if (XContentFactory.xContentType(this.facetsBinary) == builder.contentType()) {
                builder.rawField("facets", this.facetsBinary);
            } else {
                builder.field("facets_binary", this.facetsBinary);
            }
        }
        if (this.highlightBuilder != null) {
            this.highlightBuilder.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    private static class ScriptField {
        private final String fieldName;
        private final String script;
        private final String lang;
        private final Map<String, Object> params;

        private ScriptField(String fieldName, String lang, String script, Map<String, Object> params) {
            this.fieldName = fieldName;
            this.lang = lang;
            this.script = script;
            this.params = params;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String script() {
            return this.script;
        }

        public String lang() {
            return this.lang;
        }

        public Map<String, Object> params() {
            return this.params;
        }
    }
}

