/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;

public class DateHistogramFacetBuilder
extends AbstractFacetBuilder {
    private String keyFieldName;
    private String valueFieldName;
    private String interval = null;
    private String zone = null;
    private DateHistogramFacet.ComparatorType comparatorType;
    private String valueScript;
    private Map<String, Object> params;
    private String lang;

    public DateHistogramFacetBuilder(String name) {
        super(name);
    }

    public DateHistogramFacetBuilder field(String field) {
        this.keyFieldName = field;
        return this;
    }

    public DateHistogramFacetBuilder keyField(String keyField) {
        this.keyFieldName = keyField;
        return this;
    }

    public DateHistogramFacetBuilder valueField(String valueField) {
        this.valueFieldName = valueField;
        return this;
    }

    public DateHistogramFacetBuilder valueScript(String valueScript) {
        this.valueScript = valueScript;
        return this;
    }

    public DateHistogramFacetBuilder param(String name, Object value) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name, value);
        return this;
    }

    public DateHistogramFacetBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public DateHistogramFacetBuilder interval(String interval) {
        this.interval = interval;
        return this;
    }

    public DateHistogramFacetBuilder zone(String zone) {
        this.zone = zone;
        return this;
    }

    public DateHistogramFacetBuilder comparator(DateHistogramFacet.ComparatorType comparatorType) {
        this.comparatorType = comparatorType;
        return this;
    }

    @Override
    public DateHistogramFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public DateHistogramFacetBuilder scope(String scope) {
        super.scope(scope);
        return this;
    }

    @Override
    public DateHistogramFacetBuilder facetFilter(FilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    @Override
    public DateHistogramFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyFieldName == null) {
            throw new SearchSourceBuilderException("field must be set on date histogram facet for facet [" + this.name + "]");
        }
        if (this.interval == null) {
            throw new SearchSourceBuilderException("interval must be set on date histogram facet for facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("date_histogram");
        if (this.valueFieldName != null) {
            builder.field("key_field", this.keyFieldName);
            builder.field("value_field", this.valueFieldName);
        } else {
            builder.field("field", this.keyFieldName);
        }
        if (this.valueScript != null) {
            builder.field("value_script", this.valueScript);
            if (this.lang != null) {
                builder.field("lang", this.lang);
            }
            if (this.params != null) {
                builder.field("params", this.params);
            }
        }
        builder.field("interval", this.interval);
        if (this.zone != null) {
            builder.field("time_zone", this.zone);
        }
        if (this.comparatorType != null) {
            builder.field("comparator", this.comparatorType.description());
        }
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params);
        builder.endObject();
        return builder;
    }
}

