/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class ValueGeoDistanceFacetCollector
extends GeoDistanceFacetCollector {
    private final String indexValueFieldName;
    private final FieldDataType valueFieldDataType;

    public ValueGeoDistanceFacetCollector(String facetName, String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries, SearchContext context, String valueFieldName) {
        super(facetName, fieldName, lat, lon, unit, geoDistance, entries, context);
        FieldMapper mapper = context.mapperService().smartNameFieldMapper(valueFieldName);
        if (mapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + valueFieldName + "]");
        }
        this.indexValueFieldName = valueFieldName;
        this.valueFieldDataType = mapper.fieldDataType();
        this.aggregator = new Aggregator(lat, lon, geoDistance, unit, entries);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        super.doSetNextReader(reader, docBase);
        ((Aggregator)this.aggregator).valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.indexValueFieldName);
    }

    public static class ValueAggregator
    implements NumericFieldData.DoubleValueInDocProc {
        GeoDistanceFacet.Entry entry;

        @Override
        public void onValue(int docId, double value) {
            ++this.entry.totalCount;
            this.entry.total += value;
            if (value < this.entry.min) {
                this.entry.min = value;
            }
            if (value > this.entry.max) {
                this.entry.max = value;
            }
        }
    }

    public static class Aggregator
    implements GeoPointFieldData.ValueInDocProc {
        protected final double lat;
        protected final double lon;
        private final GeoDistance geoDistance;
        private final DistanceUnit unit;
        private final GeoDistanceFacet.Entry[] entries;
        NumericFieldData valueFieldData;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public Aggregator(double lat, double lon, GeoDistance geoDistance, DistanceUnit unit, GeoDistanceFacet.Entry[] entries) {
            this.lat = lat;
            this.lon = lon;
            this.geoDistance = geoDistance;
            this.unit = unit;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double lat, double lon) {
            double distance = this.geoDistance.calculate(this.lat, this.lon, lat, lon, this.unit);
            for (GeoDistanceFacet.Entry entry : this.entries) {
                if (entry.foundInDoc || !(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                entry.foundInDoc = true;
                ++entry.count;
                this.valueAggregator.entry = entry;
                this.valueFieldData.forEachValueInDoc(docId, this.valueAggregator);
            }
        }
    }
}

