/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.vectorhighlight.CustomFieldQuery;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.MarginFragListBuilder;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SingleFragListBuilder;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.lucene.document.SingleFieldSelector;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.SearchHitPhase;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlighterParseElement;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.highlight.vectorhighlight.SourceScoreOrderFragmentsBuilder;
import org.elasticsearch.search.highlight.vectorhighlight.SourceSimpleFragmentsBuilder;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class HighlightPhase
implements SearchHitPhase {
    private static final Encoder DEFAULT_ENCODER = new DefaultEncoder();

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("highlight", new HighlighterParseElement());
    }

    @Override
    public boolean executionNeeded(SearchContext context) {
        return context.highlight() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SearchContext context, SearchHitPhase.HitContext hitContext) throws ElasticSearchException {
        try {
            DocumentMapper documentMapper = context.mapperService().documentMapper(hitContext.hit().type());
            HashMap<String, HighlightField> highlightFields = Maps.newHashMap();
            for (SearchContextHighlight.Field field : context.highlight().fields()) {
                String[] fragments;
                MapperService.SmartNameFieldMappers fullMapper;
                FieldMapper mapper = documentMapper.mappers().smartNameFieldMapper(field.field());
                if (mapper == null && ((fullMapper = context.mapperService().smartName(field.field())) == null || !fullMapper.hasDocMapper() || !fullMapper.docMapper().type().equals(hitContext.hit().type()) || (mapper = fullMapper.mapper()) == null)) continue;
                if (mapper.termVector() != Field.TermVector.WITH_POSITIONS_OFFSETS) {
                    int i;
                    String[] fragments2;
                    List<Object> textsToHighlight;
                    if (!context.queryRewritten()) {
                        try {
                            context.updateRewriteQuery(context.searcher().rewrite(context.query()));
                        }
                        catch (IOException e) {
                            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + field.field() + "]", (Throwable)e);
                        }
                    }
                    QueryScorer queryScorer = new QueryScorer(context.parsedQuery().query(), null);
                    queryScorer.setExpandMultiTermQuery(true);
                    Object fragmenter = field.numberOfFragments() == 0 ? new NullFragmenter() : new SimpleSpanFragmenter(queryScorer, field.fragmentCharSize());
                    SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(field.preTags()[0], field.postTags()[0]);
                    Highlighter highlighter = new Highlighter((Formatter)formatter, DEFAULT_ENCODER, (Scorer)queryScorer);
                    highlighter.setTextFragmenter((Fragmenter)fragmenter);
                    if (mapper.stored()) {
                        try {
                            Document doc = hitContext.reader().document(hitContext.docId(), (FieldSelector)new SingleFieldSelector(mapper.names().indexName()));
                            textsToHighlight = new ArrayList<Object>(doc.getFields().size());
                            for (Fieldable docField : doc.getFields()) {
                                if (docField.stringValue() == null) continue;
                                textsToHighlight.add(docField.stringValue());
                            }
                        }
                        catch (Exception e) {
                            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + field.field() + "]", (Throwable)e);
                        }
                    } else {
                        SearchLookup lookup = context.lookup();
                        lookup.setNextReader(hitContext.reader());
                        lookup.setNextDocId(hitContext.docId());
                        textsToHighlight = lookup.source().getValues(mapper.names().fullName());
                    }
                    int numberOfFragments = field.numberOfFragments() == 0 ? 1 : field.numberOfFragments();
                    ArrayList<TextFragment> fragsList = new ArrayList<TextFragment>();
                    try {
                        for (Object textToHighlight : textsToHighlight) {
                            TextFragment[] bestTextFragments;
                            String text = textToHighlight.toString();
                            Analyzer analyzer = context.mapperService().documentMapper(hitContext.hit().type()).mappers().indexAnalyzer();
                            TokenStream tokenStream = analyzer.reusableTokenStream(mapper.names().indexName(), (Reader)new FastStringReader(text));
                            for (TextFragment bestTextFragment : bestTextFragments = highlighter.getBestTextFragments(tokenStream, text, false, numberOfFragments)) {
                                if (bestTextFragment == null || !(bestTextFragment.getScore() > 0.0f)) continue;
                                fragsList.add(bestTextFragment);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + field.field() + "]", (Throwable)e);
                    }
                    if (field.scoreOrdered().booleanValue()) {
                        Collections.sort(fragsList, new Comparator<TextFragment>(){

                            @Override
                            public int compare(TextFragment o1, TextFragment o2) {
                                return Math.round(o2.getScore() - o1.getScore());
                            }
                        });
                    }
                    if (field.numberOfFragments() == 0 && textsToHighlight.size() > 1) {
                        fragments2 = new String[1];
                        for (i = 0; i < fragsList.size(); ++i) {
                            fragments2[0] = (fragments2[0] != null ? fragments2[0] + " " : "") + ((TextFragment)fragsList.get(i)).toString();
                        }
                    } else {
                        numberOfFragments = fragsList.size() < numberOfFragments ? fragsList.size() : numberOfFragments;
                        fragments2 = new String[numberOfFragments];
                        for (i = 0; i < fragments2.length; ++i) {
                            fragments2[i] = ((TextFragment)fragsList.get(i)).toString();
                        }
                    }
                    if (fragments2.length <= 0) continue;
                    HighlightField highlightField = new HighlightField(field.field(), fragments2);
                    highlightFields.put(highlightField.name(), highlightField);
                    continue;
                }
                FastVectorHighlighter highlighter = this.buildHighlighter(context, mapper, field);
                FieldQuery fieldQuery = this.buildFieldQuery(highlighter, context.query(), hitContext.reader(), field);
                try {
                    int numberOfFragments = field.numberOfFragments() == 0 ? 1 : field.numberOfFragments();
                    fragments = highlighter.getBestFragments(fieldQuery, hitContext.reader(), hitContext.docId(), mapper.names().indexName(), field.fragmentCharSize(), numberOfFragments);
                }
                catch (IOException e) {
                    throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + field.field() + "]", (Throwable)e);
                }
                if (fragments == null || fragments.length <= 0) continue;
                HighlightField highlightField = new HighlightField(field.field(), fragments);
                highlightFields.put(highlightField.name(), highlightField);
            }
            hitContext.hit().highlightFields(highlightFields);
        }
        finally {
            CustomFieldQuery.reader.remove();
            CustomFieldQuery.highlightFilters.remove();
        }
    }

    private FieldQuery buildFieldQuery(FastVectorHighlighter highlighter, Query query, IndexReader indexReader, SearchContextHighlight.Field field) {
        CustomFieldQuery.reader.set(indexReader);
        CustomFieldQuery.highlightFilters.set(field.highlightFilter());
        return new CustomFieldQuery(query, highlighter);
    }

    private FastVectorHighlighter buildHighlighter(SearchContext searchContext, FieldMapper fieldMapper, SearchContextHighlight.Field field) {
        Object fragmentsBuilder;
        Object fragListBuilder;
        if (field.numberOfFragments() == 0) {
            fragListBuilder = new SingleFragListBuilder();
            fragmentsBuilder = fieldMapper.stored() ? new SimpleFragmentsBuilder(field.preTags(), field.postTags()) : new SourceSimpleFragmentsBuilder(fieldMapper, searchContext, field.preTags(), field.postTags());
        } else {
            fragListBuilder = field.fragmentOffset() == -1 ? new SimpleFragListBuilder() : new MarginFragListBuilder(field.fragmentOffset());
            fragmentsBuilder = field.scoreOrdered().booleanValue() ? (fieldMapper.stored() ? new ScoreOrderFragmentsBuilder(field.preTags(), field.postTags()) : new SourceScoreOrderFragmentsBuilder(fieldMapper, searchContext, field.preTags(), field.postTags())) : (fieldMapper.stored() ? new SimpleFragmentsBuilder(field.preTags(), field.postTags()) : new SourceSimpleFragmentsBuilder(fieldMapper, searchContext, field.preTags(), field.postTags()));
        }
        return new FastVectorHighlighter(true, false, (FragListBuilder)fragListBuilder, (FragmentsBuilder)fragmentsBuilder);
    }
}

