/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

final class FieldInfo {
    final String name;
    final int number;
    boolean isIndexed;
    boolean storeTermVector;
    boolean storeOffsetWithTermVector;
    boolean storePositionWithTermVector;
    boolean omitNorms;
    boolean omitTermFreqAndPositions;
    boolean storePayloads;

    FieldInfo(String na, boolean tk, int nu, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms, boolean storePayloads, boolean omitTermFreqAndPositions) {
        this.name = na;
        this.isIndexed = tk;
        this.number = nu;
        if (this.isIndexed) {
            this.storeTermVector = storeTermVector;
            this.storeOffsetWithTermVector = storeOffsetWithTermVector;
            this.storePositionWithTermVector = storePositionWithTermVector;
            this.storePayloads = storePayloads;
            this.omitNorms = omitNorms;
            this.omitTermFreqAndPositions = omitTermFreqAndPositions;
        } else {
            this.storeTermVector = false;
            this.storeOffsetWithTermVector = false;
            this.storePositionWithTermVector = false;
            this.storePayloads = false;
            this.omitNorms = true;
            this.omitTermFreqAndPositions = false;
        }
        assert (!omitTermFreqAndPositions || !storePayloads);
    }

    public Object clone() {
        return new FieldInfo(this.name, this.isIndexed, this.number, this.storeTermVector, this.storePositionWithTermVector, this.storeOffsetWithTermVector, this.omitNorms, this.storePayloads, this.omitTermFreqAndPositions);
    }

    void update(boolean isIndexed, boolean storeTermVector, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean omitNorms, boolean storePayloads, boolean omitTermFreqAndPositions) {
        if (this.isIndexed != isIndexed) {
            this.isIndexed = true;
        }
        if (isIndexed) {
            if (this.storeTermVector != storeTermVector) {
                this.storeTermVector = true;
            }
            if (this.storePositionWithTermVector != storePositionWithTermVector) {
                this.storePositionWithTermVector = true;
            }
            if (this.storeOffsetWithTermVector != storeOffsetWithTermVector) {
                this.storeOffsetWithTermVector = true;
            }
            if (this.storePayloads != storePayloads) {
                this.storePayloads = true;
            }
            if (this.omitNorms != omitNorms) {
                this.omitNorms = false;
            }
            if (this.omitTermFreqAndPositions != omitTermFreqAndPositions) {
                this.omitTermFreqAndPositions = true;
                this.storePayloads = false;
            }
        }
        assert (!this.omitTermFreqAndPositions || !this.storePayloads);
    }
}

