/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReaderUtil {
    private ReaderUtil() {
    }

    public static void gatherSubReaders(List<IndexReader> allSubReaders, IndexReader reader) {
        IndexReader[] subReaders = reader.getSequentialSubReaders();
        if (subReaders == null) {
            allSubReaders.add(reader);
        } else {
            for (int i = 0; i < subReaders.length; ++i) {
                ReaderUtil.gatherSubReaders(allSubReaders, subReaders[i]);
            }
        }
    }

    public static IndexReader subReader(int doc, IndexReader reader) {
        ArrayList<IndexReader> subReadersList = new ArrayList<IndexReader>();
        ReaderUtil.gatherSubReaders(subReadersList, reader);
        IndexReader[] subReaders = subReadersList.toArray(new IndexReader[subReadersList.size()]);
        int[] docStarts = new int[subReaders.length];
        int maxDoc = 0;
        for (int i = 0; i < subReaders.length; ++i) {
            docStarts[i] = maxDoc;
            maxDoc += subReaders[i].maxDoc();
        }
        return subReaders[ReaderUtil.subIndex(doc, docStarts)];
    }

    public static IndexReader subReader(IndexReader reader, int subIndex) {
        ArrayList<IndexReader> subReadersList = new ArrayList<IndexReader>();
        ReaderUtil.gatherSubReaders(subReadersList, reader);
        IndexReader[] subReaders = subReadersList.toArray(new IndexReader[subReadersList.size()]);
        return subReaders[subIndex];
    }

    public static int subIndex(int n, int[] docStarts) {
        int size = docStarts.length;
        int lo = 0;
        int hi = size - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = docStarts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < size && docStarts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    public static abstract class Gather {
        private final IndexReader topReader;

        public Gather(IndexReader r) {
            this.topReader = r;
        }

        public int run() throws IOException {
            return this.run(0, this.topReader);
        }

        public int run(int docBase) throws IOException {
            return this.run(docBase, this.topReader);
        }

        private int run(int base, IndexReader reader) throws IOException {
            IndexReader[] subReaders = reader.getSequentialSubReaders();
            if (subReaders == null) {
                this.add(base, reader);
                base += reader.maxDoc();
            } else {
                for (int i = 0; i < subReaders.length; ++i) {
                    base = this.run(base, subReaders[i]);
                }
            }
            return base;
        }

        protected abstract void add(int var1, IndexReader var2) throws IOException;
    }
}

