/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.Version;

public class UniqueTokenFilter
extends TokenFilter {
    private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final CharArraySet previous = new CharArraySet(Version.LUCENE_31, 8, false);
    private final boolean onlyOnSamePosition;

    public UniqueTokenFilter(TokenStream in) {
        this(in, false);
    }

    public UniqueTokenFilter(TokenStream in, boolean onlyOnSamePosition) {
        super(in);
        this.onlyOnSamePosition = onlyOnSamePosition;
    }

    public final boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            boolean duplicate;
            char[] term = this.termAttribute.buffer();
            int length = this.termAttribute.length();
            if (this.onlyOnSamePosition) {
                int posIncrement = this.posIncAttribute.getPositionIncrement();
                if (posIncrement > 0) {
                    this.previous.clear();
                }
                duplicate = posIncrement == 0 && this.previous.contains(term, 0, length);
            } else {
                duplicate = this.previous.contains(term, 0, length);
            }
            char[] saved = new char[length];
            System.arraycopy(term, 0, saved, 0, length);
            this.previous.add(saved);
            if (duplicate) continue;
            return true;
        }
        return false;
    }

    public final void reset() throws IOException {
        super.reset();
        this.previous.clear();
    }
}

