/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.network.NetworkInfo;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.transport.TransportInfo;

public class NodeInfo
extends NodeOperationResponse {
    private ImmutableMap<String, String> attributes;
    private Settings settings;
    private OsInfo os;
    private ProcessInfo process;
    private JvmInfo jvm;
    private NetworkInfo network;
    private TransportInfo transport;
    private HttpInfo http;

    NodeInfo() {
    }

    public NodeInfo(DiscoveryNode node, ImmutableMap<String, String> attributes, Settings settings, OsInfo os, ProcessInfo process, JvmInfo jvm, NetworkInfo network, TransportInfo transport, @Nullable HttpInfo http) {
        super(node);
        this.attributes = attributes;
        this.settings = settings;
        this.os = os;
        this.process = process;
        this.jvm = jvm;
        this.network = network;
        this.transport = transport;
    }

    public ImmutableMap<String, String> attributes() {
        return this.attributes;
    }

    public ImmutableMap<String, String> getAttributes() {
        return this.attributes();
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings getSettings() {
        return this.settings();
    }

    public OsInfo os() {
        return this.os;
    }

    public OsInfo getOs() {
        return this.os();
    }

    public ProcessInfo process() {
        return this.process;
    }

    public ProcessInfo getProcess() {
        return this.process();
    }

    public JvmInfo jvm() {
        return this.jvm;
    }

    public JvmInfo getJvm() {
        return this.jvm();
    }

    public NetworkInfo network() {
        return this.network;
    }

    public NetworkInfo getNetwork() {
        return this.network();
    }

    public TransportInfo transport() {
        return this.transport;
    }

    public TransportInfo getTransport() {
        return this.transport();
    }

    public HttpInfo http() {
        return this.http;
    }

    public HttpInfo getHttp() {
        return this.http();
    }

    public static NodeInfo readNodeInfo(StreamInput in) throws IOException {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.readFrom(in);
        return nodeInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            builder.put(in.readUTF(), in.readUTF());
        }
        this.attributes = builder.build();
        this.settings = ImmutableSettings.readSettingsFromStream(in);
        if (in.readBoolean()) {
            this.os = OsInfo.readOsInfo(in);
        }
        if (in.readBoolean()) {
            this.process = ProcessInfo.readProcessInfo(in);
        }
        if (in.readBoolean()) {
            this.jvm = JvmInfo.readJvmInfo(in);
        }
        if (in.readBoolean()) {
            this.network = NetworkInfo.readNetworkInfo(in);
        }
        if (in.readBoolean()) {
            this.transport = TransportInfo.readTransportInfo(in);
        }
        if (in.readBoolean()) {
            this.http = HttpInfo.readHttpInfo(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.attributes.size());
        for (Map.Entry entry : this.attributes.entrySet()) {
            out.writeUTF((String)entry.getKey());
            out.writeUTF((String)entry.getValue());
        }
        ImmutableSettings.writeSettingsToStream(this.settings, out);
        if (this.os == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.os.writeTo(out);
        }
        if (this.process == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.process.writeTo(out);
        }
        if (this.jvm == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.jvm.writeTo(out);
        }
        if (this.network == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.network.writeTo(out);
        }
        if (this.transport == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.transport.writeTo(out);
        }
        if (this.http == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.http.writeTo(out);
        }
    }
}

