/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodesShutdownRequest;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodesShutdownResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.VoidTransportResponseHandler;

public class TransportNodesShutdownAction
extends TransportMasterNodeOperationAction<NodesShutdownRequest, NodesShutdownResponse> {
    private final Node node;
    private final ClusterName clusterName;
    private final boolean disabled;
    private final TimeValue delay;

    @Inject
    public TransportNodesShutdownAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Node node, ClusterName clusterName) {
        super(settings, transportService, clusterService, threadPool);
        this.node = node;
        this.clusterName = clusterName;
        this.disabled = this.componentSettings.getAsBoolean("disabled", false);
        this.delay = this.componentSettings.getAsTime("delay", TimeValue.timeValueMillis(200L));
        this.transportService.registerHandler("/cluster/nodes/shutdown/node", new NodeShutdownRequestHandler());
    }

    @Override
    protected String executor() {
        return "cached";
    }

    @Override
    protected String transportAction() {
        return "/cluster/nodes/shutdown";
    }

    @Override
    protected NodesShutdownRequest newRequest() {
        return new NodesShutdownRequest();
    }

    @Override
    protected NodesShutdownResponse newResponse() {
        return new NodesShutdownResponse();
    }

    @Override
    protected void processBeforeDelegationToMaster(NodesShutdownRequest request, ClusterState state) {
        String[] nodesIds = request.nodesIds;
        if (nodesIds != null) {
            for (int i = 0; i < nodesIds.length; ++i) {
                if (!"_local".equals(nodesIds[i])) continue;
                nodesIds[i] = state.nodes().localNodeId();
            }
        }
    }

    @Override
    protected NodesShutdownResponse masterOperation(final NodesShutdownRequest request, final ClusterState state) throws ElasticSearchException {
        if (this.disabled) {
            throw new ElasticSearchIllegalStateException("Shutdown is disabled");
        }
        HashSet<DiscoveryNode> nodes = Sets.newHashSet();
        if (state.nodes().isAllNodes(request.nodesIds)) {
            this.logger.info("[cluster_shutdown]: requested, shutting down in [{}]", request.delay);
            nodes.addAll(state.nodes().dataNodes().values());
            nodes.addAll(state.nodes().masterNodes().values());
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(request.delay.millis());
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: stopping the cluster service so no re-routing will occur", new Object[0]);
                    TransportNodesShutdownAction.this.clusterService.stop();
                    final CountDownLatch latch = new CountDownLatch(state.nodes().size());
                    for (final DiscoveryNode node : state.nodes()) {
                        if (node.id().equals(state.nodes().masterNodeId())) {
                            latch.countDown();
                            continue;
                        }
                        TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: sending shutdown request to [{}]", node);
                        TransportNodesShutdownAction.this.transportService.sendRequest(node, "/cluster/nodes/shutdown/node", new NodeShutdownRequest(request.exit), new VoidTransportResponseHandler("same"){

                            @Override
                            public void handleResponse(VoidStreamable response) {
                                TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: received shutdown response from [{}]", node);
                                latch.countDown();
                            }

                            @Override
                            public void handleException(TransportException exp) {
                                TransportNodesShutdownAction.this.logger.warn("[cluster_shutdown]: received failed shutdown response from [{}]", exp, node);
                                latch.countDown();
                            }
                        });
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    TransportNodesShutdownAction.this.logger.info("[cluster_shutdown]: done shutting down all nodes except master, proceeding to master", new Object[0]);
                    TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: shutting down the master [{}]", state.nodes().masterNode());
                    TransportNodesShutdownAction.this.transportService.sendRequest(state.nodes().masterNode(), "/cluster/nodes/shutdown/node", new NodeShutdownRequest(request.exit), new VoidTransportResponseHandler("same"){

                        @Override
                        public void handleResponse(VoidStreamable response) {
                            TransportNodesShutdownAction.this.logger.trace("[cluster_shutdown]: received shutdown response from master", new Object[0]);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            TransportNodesShutdownAction.this.logger.warn("[cluster_shutdown]: received failed shutdown response master", exp, new Object[0]);
                        }
                    });
                }
            });
            t.start();
        } else {
            final String[] nodesIds = state.nodes().resolveNodes(request.nodesIds);
            this.logger.info("[partial_cluster_shutdown]: requested, shutting down [{}] in [{}]", nodesIds, request.delay);
            for (String nodeId : nodesIds) {
                DiscoveryNode node = state.nodes().get(nodeId);
                if (node == null) continue;
                nodes.add(node);
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(request.delay.millis());
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    final CountDownLatch latch = new CountDownLatch(nodesIds.length);
                    for (String nodeId : nodesIds) {
                        final DiscoveryNode node = state.nodes().get(nodeId);
                        if (node == null) {
                            TransportNodesShutdownAction.this.logger.warn("[partial_cluster_shutdown]: no node to shutdown for node_id [{}]", nodeId);
                            latch.countDown();
                            continue;
                        }
                        TransportNodesShutdownAction.this.logger.trace("[partial_cluster_shutdown]: sending shutdown request to [{}]", node);
                        TransportNodesShutdownAction.this.transportService.sendRequest(node, "/cluster/nodes/shutdown/node", new NodeShutdownRequest(request.exit), new VoidTransportResponseHandler("same"){

                            @Override
                            public void handleResponse(VoidStreamable response) {
                                TransportNodesShutdownAction.this.logger.trace("[partial_cluster_shutdown]: received shutdown response from [{}]", node);
                                latch.countDown();
                            }

                            @Override
                            public void handleException(TransportException exp) {
                                TransportNodesShutdownAction.this.logger.warn("[partial_cluster_shutdown]: received failed shutdown response from [{}]", exp, node);
                                latch.countDown();
                            }
                        });
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    TransportNodesShutdownAction.this.logger.info("[partial_cluster_shutdown]: done shutting down [{}]", new Object[]{nodesIds});
                }
            });
            t.start();
        }
        return new NodesShutdownResponse(this.clusterName, nodes.toArray(new DiscoveryNode[nodes.size()]));
    }

    static class NodeShutdownRequest
    implements Streamable {
        boolean exit;

        NodeShutdownRequest() {
        }

        NodeShutdownRequest(boolean exit) {
            this.exit = exit;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.exit = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.exit);
        }
    }

    private class NodeShutdownRequestHandler
    extends BaseTransportRequestHandler<NodeShutdownRequest> {
        static final String ACTION = "/cluster/nodes/shutdown/node";

        private NodeShutdownRequestHandler() {
        }

        @Override
        public NodeShutdownRequest newInstance() {
            return new NodeShutdownRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(final NodeShutdownRequest request, TransportChannel channel) throws Exception {
            if (TransportNodesShutdownAction.this.disabled) {
                throw new ElasticSearchIllegalStateException("Shutdown is disabled");
            }
            TransportNodesShutdownAction.this.logger.info("shutting down in [{}]", TransportNodesShutdownAction.this.delay);
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.sleep(TransportNodesShutdownAction.this.delay.millis());
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!request.exit) {
                        TransportNodesShutdownAction.this.logger.info("initiating requested shutdown (no exit)...", new Object[0]);
                        try {
                            TransportNodesShutdownAction.this.node.close();
                        }
                        catch (Exception e) {
                            TransportNodesShutdownAction.this.logger.warn("Failed to shutdown", e, new Object[0]);
                        }
                        return;
                    }
                    boolean shutdownWithWrapper = false;
                    if (System.getProperty("elasticsearch-service") != null) {
                        try {
                            Class<?> wrapperManager = TransportNodesShutdownAction.this.settings.getClassLoader().loadClass("org.tanukisoftware.wrapper.WrapperManager");
                            TransportNodesShutdownAction.this.logger.info("initiating requested shutdown (using service)", new Object[0]);
                            wrapperManager.getMethod("stopAndReturn", Integer.TYPE).invoke(null, 0);
                            shutdownWithWrapper = true;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    if (!shutdownWithWrapper) {
                        TransportNodesShutdownAction.this.logger.info("initiating requested shutdown...", new Object[0]);
                        try {
                            TransportNodesShutdownAction.this.node.close();
                        }
                        catch (Exception e) {
                            TransportNodesShutdownAction.this.logger.warn("Failed to shutdown", e, new Object[0]);
                        }
                        finally {
                            System.exit(0);
                        }
                    }
                }
            });
            t.start();
            channel.sendResponse(VoidStreamable.INSTANCE);
        }
    }
}

