/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.ping.single;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.ping.single.SinglePingRequest;
import org.elasticsearch.action.admin.cluster.ping.single.SinglePingResponse;
import org.elasticsearch.action.support.single.shard.TransportShardSingleOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSinglePingAction
extends TransportShardSingleOperationAction<SinglePingRequest, SinglePingResponse> {
    @Inject
    public TransportSinglePingAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, threadPool, clusterService, transportService);
    }

    @Override
    protected String executor() {
        return "cached";
    }

    @Override
    protected String transportAction() {
        return "/cluster/ping/single";
    }

    @Override
    protected String transportShardAction() {
        return "/cluster/ping/single/shard";
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, SinglePingRequest request) throws ElasticSearchException {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.index(), request.type, request.id, null, null);
    }

    @Override
    protected SinglePingResponse shardOperation(SinglePingRequest request, int shardId) throws ElasticSearchException {
        return new SinglePingResponse();
    }

    @Override
    protected SinglePingRequest newRequest() {
        return new SinglePingRequest();
    }

    @Override
    protected SinglePingResponse newResponse() {
        return new SinglePingResponse();
    }
}

