/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class CreateIndexRequest
extends MasterNodeOperationRequest {
    private String cause = "";
    private String index;
    private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
    private Map<String, String> mappings = Maps.newHashMap();
    private TimeValue timeout = new TimeValue(10L, TimeUnit.SECONDS);

    CreateIndexRequest() {
    }

    public CreateIndexRequest(String index) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public CreateIndexRequest(String index, Settings settings) {
        this.index = index;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = Actions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    String index() {
        return this.index;
    }

    Settings settings() {
        return this.settings;
    }

    String cause() {
        return this.cause;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateIndexRequest settings(String source) {
        this.settings = ImmutableSettings.settingsBuilder().loadFromSource(source).build();
        return this;
    }

    public CreateIndexRequest settings(XContentBuilder builder) {
        try {
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate json settings from builder", e);
        }
        return this;
    }

    public CreateIndexRequest settings(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public CreateIndexRequest mapping(String type, String source) {
        this.mappings.put(type, source);
        return this;
    }

    public CreateIndexRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public CreateIndexRequest mapping(String type, XContentBuilder source) {
        try {
            this.mappings.put(type, source.string());
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to build json for mapping request", e);
        }
        return this;
    }

    public CreateIndexRequest mapping(String type, Map source) {
        if (source.size() != 1 || !source.containsKey(type)) {
            source = MapBuilder.newMapBuilder().put(type, source).map();
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            return this.mapping(type, builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    Map<String, String> mappings() {
        return this.mappings;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public CreateIndexRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public CreateIndexRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.cause = in.readUTF();
        this.index = in.readUTF();
        this.settings = ImmutableSettings.readSettingsFromStream(in);
        this.timeout = TimeValue.readTimeValue(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.mappings.put(in.readUTF(), in.readUTF());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeUTF(this.cause);
        out.writeUTF(this.index);
        ImmutableSettings.writeSettingsToStream(this.settings, out);
        this.timeout.writeTo(out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
    }
}

