/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.IndicesReplicationOperationRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public class DeleteByQueryRequest
extends IndicesReplicationOperationRequest {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private byte[] querySource;
    private int querySourceOffset;
    private int querySourceLength;
    private boolean querySourceUnsafe;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;

    public DeleteByQueryRequest(String ... indices) {
        this.indices = indices;
    }

    public DeleteByQueryRequest() {
    }

    @Override
    public DeleteByQueryRequest listenerThreaded(boolean threadedListener) {
        super.listenerThreaded(threadedListener);
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.querySource == null) {
            validationException = Actions.addValidationError("query is missing", validationException);
        }
        return validationException;
    }

    @Override
    public DeleteByQueryRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    byte[] querySource() {
        if (this.querySourceUnsafe || this.querySourceOffset > 0) {
            this.querySource = Arrays.copyOfRange(this.querySource, this.querySourceOffset, this.querySourceOffset + this.querySourceLength);
            this.querySourceOffset = 0;
            this.querySourceUnsafe = false;
        }
        return this.querySource;
    }

    @Required
    public DeleteByQueryRequest query(QueryBuilder queryBuilder) {
        BytesStream bos = queryBuilder.buildAsUnsafeBytes();
        this.querySource = bos.unsafeByteArray();
        this.querySourceOffset = 0;
        this.querySourceLength = bos.size();
        this.querySourceUnsafe = true;
        return this;
    }

    @Required
    public DeleteByQueryRequest query(String querySource) {
        UnicodeUtil.UTF8Result result = Unicode.fromStringAsUtf8(querySource);
        this.querySource = result.result;
        this.querySourceOffset = 0;
        this.querySourceLength = result.length;
        this.querySourceUnsafe = true;
        return this;
    }

    @Required
    public DeleteByQueryRequest query(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(querySource);
            return this.query(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + querySource + "]", e);
        }
    }

    @Required
    public DeleteByQueryRequest query(XContentBuilder builder) {
        try {
            this.querySource = builder.unsafeBytes();
            this.querySourceOffset = 0;
            this.querySourceLength = builder.unsafeBytesLength();
            this.querySourceUnsafe = true;
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + builder + "]", e);
        }
    }

    @Required
    public DeleteByQueryRequest query(byte[] querySource) {
        return this.query(querySource, 0, querySource.length, false);
    }

    @Required
    public DeleteByQueryRequest query(byte[] querySource, int offset, int length, boolean unsafe) {
        this.querySource = querySource;
        this.querySourceOffset = offset;
        this.querySourceLength = length;
        this.querySourceUnsafe = unsafe;
        return this;
    }

    String[] types() {
        return this.types;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    public DeleteByQueryRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public DeleteByQueryRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public DeleteByQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public DeleteByQueryRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public DeleteByQueryRequest timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, null);
        return this;
    }

    public DeleteByQueryRequest replicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    public DeleteByQueryRequest consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public DeleteByQueryRequest replicationType(String replicationType) {
        this.replicationType = ReplicationType.fromString(replicationType);
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size;
        super.readFrom(in);
        this.querySourceUnsafe = false;
        this.querySourceOffset = 0;
        this.querySourceLength = in.readVInt();
        this.querySource = new byte[this.querySourceLength];
        in.readFully(this.querySource);
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
        if ((size = in.readVInt()) == 0) {
            this.types = Strings.EMPTY_ARRAY;
        } else {
            this.types = new String[size];
            for (int i = 0; i < size; ++i) {
                this.types[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.querySourceLength);
        out.writeBytes(this.querySource, this.querySourceOffset, this.querySourceLength);
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
    }

    public String toString() {
        return "[" + Arrays.toString(this.indices) + "][" + Arrays.toString(this.types) + "], querySource[" + Unicode.fromBytes(this.querySource) + "]";
    }
}

