/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryResponse;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardDeleteByQueryAction
extends TransportShardReplicationOperationAction<ShardDeleteByQueryRequest, ShardDeleteByQueryResponse> {
    @Inject
    public TransportShardDeleteByQueryAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected ShardDeleteByQueryRequest newRequestInstance() {
        return new ShardDeleteByQueryRequest();
    }

    @Override
    protected ShardDeleteByQueryResponse newResponseInstance() {
        return new ShardDeleteByQueryResponse();
    }

    @Override
    protected String transportAction() {
        return "indices/index/shard/deleteByQuery";
    }

    @Override
    protected void checkBlock(ShardDeleteByQueryRequest request, ClusterState state) {
        state.blocks().indexBlockedRaiseException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteByQueryResponse> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
        ShardDeleteByQueryRequest request = (ShardDeleteByQueryRequest)shardRequest.request;
        this.indexShard(shardRequest).deleteByQuery(request.querySource(), request.filteringAliases(), request.types());
        return new TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteByQueryResponse>(new ShardDeleteByQueryResponse(), null);
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ShardOperationRequest shardRequest) {
        ShardDeleteByQueryRequest request = (ShardDeleteByQueryRequest)shardRequest.request;
        this.indexShard(shardRequest).deleteByQuery(request.querySource(), request.filteringAliases(), request.types());
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, ShardDeleteByQueryRequest request) {
        GroupShardsIterator group = this.clusterService.operationRouting().deleteByQueryShards(this.clusterService.state(), request.index(), request.routing());
        for (ShardIterator shardIt : group) {
            if (shardIt.shardId().id() != request.shardId()) continue;
            return shardIt;
        }
        throw new ElasticSearchIllegalStateException("No shards iterator found for shard [" + request.shardId() + "]");
    }
}

