/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class MultiGetResponse
implements ActionResponse,
Iterable<MultiGetItemResponse>,
ToXContent {
    private MultiGetItemResponse[] responses;

    MultiGetResponse() {
    }

    public MultiGetResponse(MultiGetItemResponse[] responses) {
        this.responses = responses;
    }

    public MultiGetItemResponse[] responses() {
        return this.responses;
    }

    @Override
    public Iterator<MultiGetItemResponse> iterator() {
        return Iterators.forArray(this.responses);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(Fields.DOCS);
        for (MultiGetItemResponse response : this.responses) {
            if (response.failed()) {
                builder.startObject();
                Failure failure = response.failure();
                builder.field(Fields._INDEX, failure.index());
                builder.field(Fields._TYPE, failure.type());
                builder.field(Fields._ID, failure.id());
                builder.field(Fields.ERROR, failure.message());
                builder.endObject();
                continue;
            }
            GetResponse getResponse = response.getResponse();
            getResponse.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.responses = new MultiGetItemResponse[in.readVInt()];
        for (int i = 0; i < this.responses.length; ++i) {
            this.responses[i] = MultiGetItemResponse.readItemResponse(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.responses.length);
        for (MultiGetItemResponse response : this.responses) {
            response.writeTo(out);
        }
    }

    static final class Fields {
        static final XContentBuilderString DOCS = new XContentBuilderString("docs");
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString ERROR = new XContentBuilderString("error");

        Fields() {
        }
    }

    public static class Failure
    implements Streamable {
        private String index;
        private String type;
        private String id;
        private String message;

        Failure() {
        }

        public Failure(String index, String type, String id, String message) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.message = message;
        }

        public String index() {
            return this.index;
        }

        public String getIndex() {
            return this.index();
        }

        public String type() {
            return this.type;
        }

        public String getType() {
            return this.type();
        }

        public String id() {
            return this.id;
        }

        public String getId() {
            return this.id;
        }

        public String message() {
            return this.message;
        }

        public String getMessage() {
            return this.message();
        }

        public static Failure readFailure(StreamInput in) throws IOException {
            Failure failure = new Failure();
            failure.readFrom(in);
            return failure;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.index = in.readUTF();
            if (in.readBoolean()) {
                this.type = in.readUTF();
            }
            this.id = in.readUTF();
            this.message = in.readUTF();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.index);
            if (this.type == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.type);
            }
            out.writeUTF(this.id);
            out.writeUTF(this.message);
        }
    }
}

