/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.list.array.TIntArrayList;

public class MultiGetShardRequest
extends SingleShardOperationRequest {
    private int shardId;
    private String preference;
    Boolean realtime;
    boolean refresh;
    TIntArrayList locations;
    List<String> types;
    List<String> ids;
    List<String[]> fields;

    MultiGetShardRequest() {
    }

    MultiGetShardRequest(String index, int shardId) {
        super(index);
        this.shardId = shardId;
        this.locations = new TIntArrayList();
        this.types = new ArrayList<String>();
        this.ids = new ArrayList<String>();
        this.fields = new ArrayList<String[]>();
    }

    public int shardId() {
        return this.shardId;
    }

    public MultiGetShardRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime == null ? true : this.realtime;
    }

    public MultiGetShardRequest realtime(Boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetShardRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public void add(int location, @Nullable String type, String id, String[] fields) {
        this.locations.add(location);
        this.types.add(type);
        this.ids.add(id);
        this.fields.add(fields);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.locations = new TIntArrayList(size);
        this.types = new ArrayList<String>(size);
        this.ids = new ArrayList<String>(size);
        this.fields = new ArrayList<String[]>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.types.add(in.readUTF());
            } else {
                this.types.add(null);
            }
            this.ids.add(in.readUTF());
            int size1 = in.readVInt();
            if (size1 > 0) {
                String[] fields = new String[size1];
                for (int j = 0; j < size1; ++j) {
                    fields[j] = in.readUTF();
                }
                this.fields.add(fields);
                continue;
            }
            this.fields.add(null);
        }
        if (in.readBoolean()) {
            this.preference = in.readUTF();
        }
        this.refresh = in.readBoolean();
        byte realtime = in.readByte();
        if (realtime == 0) {
            this.realtime = false;
        } else if (realtime == 1) {
            this.realtime = true;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.types.size());
        for (int i = 0; i < this.types.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.types.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.types.get(i));
            }
            out.writeUTF(this.ids.get(i));
            if (this.fields.get(i) == null) {
                out.writeVInt(0);
                continue;
            }
            out.writeVInt(this.fields.get(i).length);
            for (String field : this.fields.get(i)) {
                out.writeUTF(field);
            }
        }
        if (this.preference == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.preference);
        }
        out.writeBoolean(this.refresh);
        if (this.realtime == null) {
            out.writeByte((byte)-1);
        } else if (!this.realtime.booleanValue()) {
            out.writeByte((byte)0);
        } else {
            out.writeByte((byte)1);
        }
    }
}

