/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetField;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.single.shard.TransportShardSingleOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.document.ResetFieldSelector;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.selector.FieldMappersFieldSelector;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAction
extends TransportShardSingleOperationAction<GetRequest, GetResponse> {
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final boolean realtime;

    @Inject
    public TransportGetAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ScriptService scriptService, ThreadPool threadPool) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.realtime = settings.getAsBoolean("action.get.realtime", true);
    }

    @Override
    protected String executor() {
        return "search";
    }

    @Override
    protected String transportAction() {
        return "indices/get";
    }

    @Override
    protected String transportShardAction() {
        return "indices/get/shard";
    }

    @Override
    protected void checkBlock(GetRequest request, ClusterState state) {
        state.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, request.index());
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, GetRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.index(), request.type(), request.id(), request.routing(), request.preference());
    }

    @Override
    protected void doExecute(GetRequest request, ActionListener<GetResponse> listener) {
        if (request.realtime == null) {
            request.realtime = this.realtime;
        }
        MetaData metaData = this.clusterService.state().metaData();
        request.routing(metaData.resolveIndexRouting(request.routing(), request.index()));
        super.doExecute(request, listener);
    }

    @Override
    protected GetResponse shardOperation(GetRequest request, int shardId) throws ElasticSearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(shardId);
        if (request.refresh() && !request.realtime()) {
            indexShard.refresh(new Engine.Refresh(false));
        }
        return TransportGetAction.load(this.logger, this.scriptService, indexService, indexShard, request.index(), request.type(), request.id(), request.fields(), request.realtime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GetResponse load(ESLogger logger, ScriptService scriptService, IndexService indexService, IndexShard indexShard, String index, String type, String id, String[] gFields, boolean realtime) throws ElasticSearchException {
        DocumentMapper docMapper;
        boolean loadSource = gFields == null || gFields.length > 0;
        Engine.GetResult get = null;
        if (type == null || type.equals("_all")) {
            for (String typeX : indexService.mapperService().types()) {
                get = indexShard.get(new Engine.Get(realtime, UidFieldMapper.TERM_FACTORY.createTerm(Uid.createUid(typeX, id))).loadSource(loadSource));
                if (get.exists()) {
                    type = typeX;
                    break;
                }
                get.release();
            }
            if (get == null) {
                return new GetResponse(index, type, id, -1L, false, null, null);
            }
            if (!get.exists()) {
                return new GetResponse(index, type, id, -1L, false, null, null);
            }
        } else {
            get = indexShard.get(new Engine.Get(realtime, UidFieldMapper.TERM_FACTORY.createTerm(Uid.createUid(type, id))).loadSource(loadSource));
            if (!get.exists()) {
                get.release();
                return new GetResponse(index, type, id, -1L, false, null, null);
            }
        }
        if ((docMapper = indexService.mapperService().documentMapper(type)) == null) {
            get.release();
            return new GetResponse(index, type, id, -1L, false, null, null);
        }
        try {
            if (get.docIdAndVersion() != null) {
                Object searchLookup;
                HashMap<String, GetField> fields = null;
                byte[] source = null;
                UidField.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
                ResetFieldSelector fieldSelector = TransportGetAction.buildFieldSelectors(docMapper, gFields);
                if (fieldSelector != null) {
                    Document doc;
                    fieldSelector.reset();
                    try {
                        doc = docIdAndVersion.reader.document(docIdAndVersion.docId, (FieldSelector)fieldSelector);
                    }
                    catch (IOException e) {
                        throw new ElasticSearchException("Failed to get type [" + type + "] and id [" + id + "]", e);
                    }
                    source = TransportGetAction.extractSource(doc, docMapper);
                    Iterator i$ = doc.getFields().iterator();
                    while (i$.hasNext()) {
                        GetField getField;
                        FieldMapper mapper;
                        Fieldable oField;
                        Fieldable field = oField = (Fieldable)i$.next();
                        String name = field.name();
                        Object value = null;
                        FieldMappers fieldMappers = docMapper.mappers().indexName(field.name());
                        if (fieldMappers != null && (mapper = fieldMappers.mapper()) != null) {
                            name = mapper.names().fullName();
                            value = mapper.valueForSearch(field);
                        }
                        if (value == null) {
                            value = field.isBinary() ? field.getBinaryValue() : (Object)field.stringValue();
                        }
                        if (fields == null) {
                            fields = Maps.newHashMapWithExpectedSize(2);
                        }
                        if ((getField = (GetField)fields.get(name)) == null) {
                            getField = new GetField(name, new ArrayList<Object>(2));
                            fields.put(name, getField);
                        }
                        getField.values().add(value);
                    }
                }
                if (gFields != null && gFields.length > 0) {
                    searchLookup = null;
                    for (String field : gFields) {
                        String script = null;
                        if (field.contains("_source.") || field.contains("doc[")) {
                            script = field;
                        } else {
                            FieldMappers x = docMapper.mappers().smartName(field);
                            if (x != null && !x.mapper().stored()) {
                                script = "_source." + x.mapper().names().fullName();
                            }
                        }
                        if (script == null) continue;
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(indexService.mapperService(), indexService.cache().fieldData());
                        }
                        SearchScript searchScript = scriptService.search((SearchLookup)searchLookup, "mvel", script, null);
                        searchScript.setNextReader(docIdAndVersion.reader);
                        searchScript.setNextDocId(docIdAndVersion.docId);
                        try {
                            GetField getField;
                            Object value = searchScript.run();
                            if (fields == null) {
                                fields = Maps.newHashMapWithExpectedSize(2);
                            }
                            if ((getField = (GetField)fields.get(field)) == null) {
                                getField = new GetField(field, new ArrayList<Object>(2));
                                fields.put(field, getField);
                            }
                            getField.values().add(value);
                        }
                        catch (RuntimeException e) {
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace("failed to execute get request script field [{}]", e, script);
                        }
                    }
                }
                searchLookup = new GetResponse(index, type, id, get.version(), get.exists(), source == null ? null : new BytesHolder(source), fields);
                return searchLookup;
            }
            BytesHolder source = get.source();
            HashMap<String, GetField> fields = null;
            boolean sourceRequested = false;
            if (gFields == null) {
                sourceRequested = true;
            } else if (gFields.length == 0) {
                sourceRequested = false;
            } else {
                Map<String, Object> sourceAsMap = SourceLookup.sourceAsMap(source.bytes(), source.offset(), source.length());
                SearchLookup searchLookup = null;
                for (String field : gFields) {
                    if (field.equals("_source")) {
                        sourceRequested = true;
                        continue;
                    }
                    String script = null;
                    if (field.contains("_source.")) {
                        script = field;
                    } else {
                        FieldMappers x = docMapper.mappers().smartName(field);
                        if (x != null) {
                            script = "_source." + x.mapper().names().fullName();
                        }
                    }
                    if (script == null) continue;
                    if (searchLookup == null) {
                        searchLookup = new SearchLookup(indexService.mapperService(), indexService.cache().fieldData());
                    }
                    SearchScript searchScript = scriptService.search(searchLookup, "mvel", script, null);
                    searchScript.setNextSource(sourceAsMap);
                    try {
                        GetField getField;
                        Object value = searchScript.run();
                        if (fields == null) {
                            fields = Maps.newHashMapWithExpectedSize(2);
                        }
                        if ((getField = (GetField)fields.get(field)) == null) {
                            getField = new GetField(field, new ArrayList<Object>(2));
                            fields.put(field, getField);
                        }
                        getField.values().add(value);
                    }
                    catch (RuntimeException e) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("failed to execute get request script field [{}]", e, script);
                    }
                }
            }
            GetResponse getResponse = new GetResponse(index, type, id, get.version(), get.exists(), sourceRequested ? source : null, fields);
            return getResponse;
        }
        finally {
            get.release();
        }
    }

    private static ResetFieldSelector buildFieldSelectors(DocumentMapper docMapper, String ... fields) {
        if (fields == null) {
            return docMapper.sourceMapper().fieldSelector();
        }
        if (fields.length == 0) {
            return null;
        }
        FieldMappersFieldSelector fieldSelector = null;
        for (String fieldName : fields) {
            FieldMappers x = docMapper.mappers().smartName(fieldName);
            if (x == null || !x.mapper().stored()) continue;
            if (fieldSelector == null) {
                fieldSelector = new FieldMappersFieldSelector();
            }
            fieldSelector.add(x);
        }
        return fieldSelector;
    }

    private static byte[] extractSource(Document doc, DocumentMapper documentMapper) {
        byte[] source = null;
        Fieldable sourceField = doc.getFieldable(documentMapper.sourceMapper().names().indexName());
        if (sourceField != null) {
            source = documentMapper.sourceMapper().nativeValue(sourceField);
            doc.removeField(documentMapper.sourceMapper().names().indexName());
        }
        return source;
    }

    @Override
    protected GetRequest newRequest() {
        return new GetRequest();
    }

    @Override
    protected GetResponse newResponse() {
        return new GetResponse();
    }
}

