/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.TransportSearchCache;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchDfsQueryAndFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchDfsQueryAndFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportSearchCache transportSearchCache, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, transportSearchCache, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<DfsSearchResult> {
        private final Collection<DfsSearchResult> dfsResults;
        private final Map<SearchShardTarget, QueryFetchSearchResult> queryFetchResults;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(TransportSearchDfsQueryAndFetchAction.this, request, listener);
            this.dfsResults = TransportSearchDfsQueryAndFetchAction.this.searchCache.obtainDfsResults();
            this.queryFetchResults = TransportSearchDfsQueryAndFetchAction.this.searchCache.obtainQueryFetchResults();
        }

        @Override
        protected String firstPhaseName() {
            return "dfs";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, InternalSearchRequest request, SearchServiceListener<DfsSearchResult> listener) {
            TransportSearchDfsQueryAndFetchAction.this.searchService.sendExecuteDfs(node, request, listener);
        }

        @Override
        protected void processFirstPhaseResult(ShardRouting shard, DfsSearchResult result) {
            this.dfsResults.add(result);
        }

        @Override
        protected void moveToSecondPhase() {
            final AggregatedDfs dfs = TransportSearchDfsQueryAndFetchAction.this.searchPhaseController.aggregateDfs(this.dfsResults);
            final AtomicInteger counter = new AtomicInteger(this.dfsResults.size());
            int localOperations = 0;
            for (DfsSearchResult dfsResult : this.dfsResults) {
                DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                if (node.id().equals(this.nodes.localNodeId())) {
                    ++localOperations;
                    continue;
                }
                QuerySearchRequest querySearchRequest = new QuerySearchRequest(dfsResult.id(), dfs);
                this.executeSecondPhase(dfsResult, counter, node, querySearchRequest);
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchDfsQueryAndFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (DfsSearchResult dfsResult : AsyncAction.this.dfsResults) {
                                DiscoveryNode node = AsyncAction.this.nodes.get(dfsResult.shardTarget().nodeId());
                                if (!node.id().equals(AsyncAction.this.nodes.localNodeId())) continue;
                                QuerySearchRequest querySearchRequest = new QuerySearchRequest(dfsResult.id(), dfs);
                                AsyncAction.this.executeSecondPhase(dfsResult, counter, node, querySearchRequest);
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final DfsSearchResult dfsResult : this.dfsResults) {
                        final DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                        if (!node.id().equals(this.nodes.localNodeId())) continue;
                        final QuerySearchRequest querySearchRequest = new QuerySearchRequest(dfsResult.id(), dfs);
                        if (localAsync) {
                            TransportSearchDfsQueryAndFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                @Override
                                public void run() {
                                    AsyncAction.this.executeSecondPhase(dfsResult, counter, node, querySearchRequest);
                                }
                            });
                            continue;
                        }
                        this.executeSecondPhase(dfsResult, counter, node, querySearchRequest);
                    }
                }
            }
        }

        void executeSecondPhase(final DfsSearchResult dfsResult, final AtomicInteger counter, DiscoveryNode node, final QuerySearchRequest querySearchRequest) {
            TransportSearchDfsQueryAndFetchAction.this.searchService.sendExecuteFetch(node, querySearchRequest, new SearchServiceListener<QueryFetchSearchResult>(){

                @Override
                public void onResult(QueryFetchSearchResult result) {
                    result.shardTarget(dfsResult.shardTarget());
                    AsyncAction.this.queryFetchResults.put(result.shardTarget(), result);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    if (TransportSearchDfsQueryAndFetchAction.this.logger.isDebugEnabled()) {
                        TransportSearchDfsQueryAndFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, querySearchRequest.id());
                    }
                    AsyncAction.this.shardFailures.add(new ShardSearchFailure(t));
                    AsyncAction.this.successulOps.decrementAndGet();
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Exception e) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("query_fetch", "", e, this.buildShardFailures());
                if (TransportSearchDfsQueryAndFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchDfsQueryAndFetchAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                this.listener.onFailure(failure);
            }
            finally {
                TransportSearchDfsQueryAndFetchAction.this.searchCache.releaseDfsResults(this.dfsResults);
                TransportSearchDfsQueryAndFetchAction.this.searchCache.releaseQueryFetchResults(this.queryFetchResults);
            }
        }

        void innerFinishHim() throws Exception {
            this.sortedShardList = TransportSearchDfsQueryAndFetchAction.this.searchPhaseController.sortDocs(this.queryFetchResults.values());
            InternalSearchResponse internalResponse = TransportSearchDfsQueryAndFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.queryFetchResults, this.queryFetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), this.dfsResults, null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

