/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.action.search;

import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.action.support.BaseRequestBuilder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.facet.AbstractFacetBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class SearchRequestBuilder
extends BaseRequestBuilder<SearchRequest, SearchResponse> {
    private SearchSourceBuilder sourceBuilder;

    public SearchRequestBuilder(Client client) {
        super(client, new SearchRequest());
    }

    public SearchRequestBuilder setIndices(String ... indices) {
        ((SearchRequest)this.request).indices(indices);
        return this;
    }

    public SearchRequestBuilder setTypes(String ... types) {
        ((SearchRequest)this.request).types(types);
        return this;
    }

    public SearchRequestBuilder setSearchType(SearchType searchType) {
        ((SearchRequest)this.request).searchType(searchType);
        return this;
    }

    public SearchRequestBuilder setSearchType(String searchType) throws ElasticSearchIllegalArgumentException {
        ((SearchRequest)this.request).searchType(searchType);
        return this;
    }

    public SearchRequestBuilder setScroll(Scroll scroll) {
        ((SearchRequest)this.request).scroll(scroll);
        return this;
    }

    public SearchRequestBuilder setScroll(TimeValue keepAlive) {
        ((SearchRequest)this.request).scroll(keepAlive);
        return this;
    }

    public SearchRequestBuilder setScroll(String keepAlive) {
        ((SearchRequest)this.request).scroll(keepAlive);
        return this;
    }

    public SearchRequestBuilder setTimeout(TimeValue timeout) {
        ((SearchRequest)this.request).timeout(timeout);
        return this;
    }

    public SearchRequestBuilder setTimeout(String timeout) {
        ((SearchRequest)this.request).timeout(timeout);
        return this;
    }

    public SearchRequestBuilder setQueryHint(String queryHint) {
        ((SearchRequest)this.request).queryHint(queryHint);
        return this;
    }

    public SearchRequestBuilder setRouting(String routing) {
        ((SearchRequest)this.request).routing(routing);
        return this;
    }

    public SearchRequestBuilder setRouting(String ... routing) {
        ((SearchRequest)this.request).routing(routing);
        return this;
    }

    public SearchRequestBuilder setPreference(String preference) {
        ((SearchRequest)this.request).preference(preference);
        return this;
    }

    public SearchRequestBuilder setOperationThreading(SearchOperationThreading operationThreading) {
        ((SearchRequest)this.request).operationThreading(operationThreading);
        return this;
    }

    public SearchRequestBuilder setOperationThreading(String operationThreading) {
        ((SearchRequest)this.request).operationThreading(operationThreading);
        return this;
    }

    public SearchRequestBuilder setListenerThreaded(boolean listenerThreaded) {
        ((SearchRequest)this.request).listenerThreaded(listenerThreaded);
        return this;
    }

    public SearchRequestBuilder setQuery(QueryBuilder queryBuilder) {
        this.sourceBuilder().query(queryBuilder);
        return this;
    }

    public SearchRequestBuilder setQuery(String query) {
        this.sourceBuilder().query(query);
        return this;
    }

    public SearchRequestBuilder setQuery(byte[] queryBinary) {
        this.sourceBuilder().query(queryBinary);
        return this;
    }

    public SearchRequestBuilder setFilter(FilterBuilder filter) {
        this.sourceBuilder().filter(filter);
        return this;
    }

    public SearchRequestBuilder setFilter(String filter) {
        this.sourceBuilder().filter(filter);
        return this;
    }

    public SearchRequestBuilder setFilter(byte[] filter) {
        this.sourceBuilder().filter(filter);
        return this;
    }

    public SearchRequestBuilder setMinScore(float minScore) {
        this.sourceBuilder().minScore(minScore);
        return this;
    }

    public SearchRequestBuilder setFrom(int from) {
        this.sourceBuilder().from(from);
        return this;
    }

    public SearchRequestBuilder setSize(int size) {
        this.sourceBuilder().size(size);
        return this;
    }

    public SearchRequestBuilder setExplain(boolean explain) {
        this.sourceBuilder().explain(explain);
        return this;
    }

    public SearchRequestBuilder setVersion(boolean version) {
        this.sourceBuilder().version(version);
        return this;
    }

    public SearchRequestBuilder addIndexBoost(String index, float indexBoost) {
        this.sourceBuilder().indexBoost(index, indexBoost);
        return this;
    }

    public SearchRequestBuilder setNoFields() {
        this.sourceBuilder().noFields();
        return this;
    }

    public SearchRequestBuilder addField(String field) {
        this.sourceBuilder().field(field);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name, String script) {
        this.sourceBuilder().scriptField(name, script);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name, String script, Map<String, Object> params) {
        this.sourceBuilder().scriptField(name, script, params);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name, String lang, String script, Map<String, Object> params) {
        this.sourceBuilder().scriptField(name, lang, script, params);
        return this;
    }

    public SearchRequestBuilder addSort(String field, SortOrder order) {
        this.sourceBuilder().sort(field, order);
        return this;
    }

    public SearchRequestBuilder addSort(SortBuilder sort) {
        this.sourceBuilder().sort(sort);
        return this;
    }

    public SearchRequestBuilder setTrackScores(boolean trackScores) {
        this.sourceBuilder().trackScores(trackScores);
        return this;
    }

    public SearchRequestBuilder addFields(String ... fields) {
        this.sourceBuilder().fields(fields);
        return this;
    }

    public SearchRequestBuilder addFacet(AbstractFacetBuilder facet) {
        this.sourceBuilder().facet(facet);
        return this;
    }

    public SearchRequestBuilder setFacets(byte[] facets) {
        this.sourceBuilder().facets(facets);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name) {
        this.highlightBuilder().field(name);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name, int fragmentSize) {
        this.highlightBuilder().field(name, fragmentSize);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name, int fragmentSize, int numberOfFragments) {
        this.highlightBuilder().field(name, fragmentSize, numberOfFragments);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name, int fragmentSize, int numberOfFragments, int fragmentOffset) {
        this.highlightBuilder().field(name, fragmentSize, numberOfFragments, fragmentOffset);
        return this;
    }

    public SearchRequestBuilder setHighlighterTagsSchema(String schemaName) {
        this.highlightBuilder().tagsSchema(schemaName);
        return this;
    }

    public SearchRequestBuilder setHighlighterPreTags(String ... preTags) {
        this.highlightBuilder().preTags(preTags);
        return this;
    }

    public SearchRequestBuilder setHighlighterPostTags(String ... postTags) {
        this.highlightBuilder().postTags(postTags);
        return this;
    }

    public SearchRequestBuilder setHighlighterOrder(String order) {
        this.highlightBuilder().order(order);
        return this;
    }

    public SearchRequestBuilder setSource(String source) {
        ((SearchRequest)this.request).source(source);
        return this;
    }

    public SearchRequestBuilder setExtraSource(String source) {
        ((SearchRequest)this.request).extraSource(source);
        return this;
    }

    public SearchRequestBuilder setSource(byte[] source) {
        ((SearchRequest)this.request).source(source);
        return this;
    }

    public SearchRequestBuilder setExtraSource(byte[] source) {
        ((SearchRequest)this.request).extraSource(source);
        return this;
    }

    public SearchRequestBuilder setSource(byte[] source, int offset, int length) {
        ((SearchRequest)this.request).source(source, offset, length);
        return this;
    }

    public SearchRequestBuilder setExtraSource(byte[] source, int offset, int length) {
        ((SearchRequest)this.request).extraSource(source, offset, length);
        return this;
    }

    public SearchRequestBuilder setSource(XContentBuilder builder) {
        ((SearchRequest)this.request).source(builder);
        return this;
    }

    public SearchRequestBuilder setExtraSource(XContentBuilder builder) {
        ((SearchRequest)this.request).extraSource(builder);
        return this;
    }

    public SearchRequestBuilder internalBuilder(SearchSourceBuilder sourceBuilder) {
        this.sourceBuilder = sourceBuilder;
        return this;
    }

    public SearchSourceBuilder internalBuilder() {
        return this.sourceBuilder();
    }

    public String toString() {
        return this.internalBuilder().toString();
    }

    @Override
    protected void doExecute(ActionListener<SearchResponse> listener) {
        ((SearchRequest)this.request).source(this.sourceBuilder());
        this.client.search((SearchRequest)this.request, listener);
    }

    private SearchSourceBuilder sourceBuilder() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new SearchSourceBuilder();
        }
        return this.sourceBuilder;
    }

    private HighlightBuilder highlightBuilder() {
        return this.sourceBuilder().highlighter();
    }
}

