/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.node;

import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.count.TransportCountAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.TransportDeleteByQueryAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.get.TransportMultiGetAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.mlt.MoreLikeThisRequest;
import org.elasticsearch.action.mlt.TransportMoreLikeThisAction;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.percolate.TransportPercolateAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.search.TransportSearchScrollAction;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.internal.InternalClient;
import org.elasticsearch.client.node.NodeAdminClient;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;

public class NodeClient
extends AbstractClient
implements InternalClient {
    private final ThreadPool threadPool;
    private final NodeAdminClient admin;
    private final TransportIndexAction indexAction;
    private final TransportDeleteAction deleteAction;
    private final TransportBulkAction bulkAction;
    private final TransportDeleteByQueryAction deleteByQueryAction;
    private final TransportGetAction getAction;
    private final TransportMultiGetAction multiGetAction;
    private final TransportCountAction countAction;
    private final TransportSearchAction searchAction;
    private final TransportSearchScrollAction searchScrollAction;
    private final TransportMoreLikeThisAction moreLikeThisAction;
    private final TransportPercolateAction percolateAction;

    @Inject
    public NodeClient(Settings settings, ThreadPool threadPool, NodeAdminClient admin, TransportIndexAction indexAction, TransportDeleteAction deleteAction, TransportBulkAction bulkAction, TransportDeleteByQueryAction deleteByQueryAction, TransportGetAction getAction, TransportMultiGetAction multiGetAction, TransportCountAction countAction, TransportSearchAction searchAction, TransportSearchScrollAction searchScrollAction, TransportMoreLikeThisAction moreLikeThisAction, TransportPercolateAction percolateAction) {
        this.threadPool = threadPool;
        this.admin = admin;
        this.indexAction = indexAction;
        this.deleteAction = deleteAction;
        this.bulkAction = bulkAction;
        this.deleteByQueryAction = deleteByQueryAction;
        this.getAction = getAction;
        this.multiGetAction = multiGetAction;
        this.countAction = countAction;
        this.searchAction = searchAction;
        this.searchScrollAction = searchScrollAction;
        this.moreLikeThisAction = moreLikeThisAction;
        this.percolateAction = percolateAction;
    }

    @Override
    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public void close() {
    }

    @Override
    public AdminClient admin() {
        return this.admin;
    }

    @Override
    public ActionFuture<IndexResponse> index(IndexRequest request) {
        return this.indexAction.execute(request);
    }

    @Override
    public void index(IndexRequest request, ActionListener<IndexResponse> listener) {
        this.indexAction.execute(request, listener);
    }

    @Override
    public ActionFuture<DeleteResponse> delete(DeleteRequest request) {
        return this.deleteAction.execute(request);
    }

    @Override
    public void delete(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        this.deleteAction.execute(request, listener);
    }

    @Override
    public ActionFuture<BulkResponse> bulk(BulkRequest request) {
        return this.bulkAction.execute(request);
    }

    @Override
    public void bulk(BulkRequest request, ActionListener<BulkResponse> listener) {
        this.bulkAction.execute(request, listener);
    }

    @Override
    public ActionFuture<DeleteByQueryResponse> deleteByQuery(DeleteByQueryRequest request) {
        return this.deleteByQueryAction.execute(request);
    }

    @Override
    public void deleteByQuery(DeleteByQueryRequest request, ActionListener<DeleteByQueryResponse> listener) {
        this.deleteByQueryAction.execute(request, listener);
    }

    @Override
    public ActionFuture<GetResponse> get(GetRequest request) {
        return this.getAction.execute(request);
    }

    @Override
    public void get(GetRequest request, ActionListener<GetResponse> listener) {
        this.getAction.execute(request, listener);
    }

    @Override
    public ActionFuture<MultiGetResponse> multiGet(MultiGetRequest request) {
        return this.multiGetAction.execute(request);
    }

    @Override
    public void multiGet(MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        this.multiGetAction.execute(request, listener);
    }

    @Override
    public ActionFuture<CountResponse> count(CountRequest request) {
        return this.countAction.execute(request);
    }

    @Override
    public void count(CountRequest request, ActionListener<CountResponse> listener) {
        this.countAction.execute(request, listener);
    }

    @Override
    public ActionFuture<SearchResponse> search(SearchRequest request) {
        return this.searchAction.execute(request);
    }

    @Override
    public void search(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.searchAction.execute(request, listener);
    }

    @Override
    public ActionFuture<SearchResponse> searchScroll(SearchScrollRequest request) {
        return this.searchScrollAction.execute(request);
    }

    @Override
    public void searchScroll(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        this.searchScrollAction.execute(request, listener);
    }

    @Override
    public ActionFuture<SearchResponse> moreLikeThis(MoreLikeThisRequest request) {
        return this.moreLikeThisAction.execute(request);
    }

    @Override
    public void moreLikeThis(MoreLikeThisRequest request, ActionListener<SearchResponse> listener) {
        this.moreLikeThisAction.execute(request, listener);
    }

    @Override
    public ActionFuture<PercolateResponse> percolate(PercolateRequest request) {
        return this.percolateAction.execute(request);
    }

    @Override
    public void percolate(PercolateRequest request, ActionListener<PercolateResponse> listener) {
        this.percolateAction.execute(request, listener);
    }
}

