/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport.support;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.restart.NodesRestartRequest;
import org.elasticsearch.action.admin.cluster.node.restart.NodesRestartResponse;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodesShutdownRequest;
import org.elasticsearch.action.admin.cluster.node.shutdown.NodesShutdownResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.ping.broadcast.BroadcastPingRequest;
import org.elasticsearch.action.admin.cluster.ping.broadcast.BroadcastPingResponse;
import org.elasticsearch.action.admin.cluster.ping.replication.ReplicationPingRequest;
import org.elasticsearch.action.admin.cluster.ping.replication.ReplicationPingResponse;
import org.elasticsearch.action.admin.cluster.ping.single.SinglePingRequest;
import org.elasticsearch.action.admin.cluster.ping.single.SinglePingResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.internal.InternalClusterAdminClient;
import org.elasticsearch.client.support.AbstractClusterAdminClient;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.client.transport.action.admin.cluster.health.ClientTransportClusterHealthAction;
import org.elasticsearch.client.transport.action.admin.cluster.node.info.ClientTransportNodesInfoAction;
import org.elasticsearch.client.transport.action.admin.cluster.node.restart.ClientTransportNodesRestartAction;
import org.elasticsearch.client.transport.action.admin.cluster.node.shutdown.ClientTransportNodesShutdownAction;
import org.elasticsearch.client.transport.action.admin.cluster.node.stats.ClientTransportNodesStatsAction;
import org.elasticsearch.client.transport.action.admin.cluster.ping.broadcast.ClientTransportBroadcastPingAction;
import org.elasticsearch.client.transport.action.admin.cluster.ping.replication.ClientTransportReplicationPingAction;
import org.elasticsearch.client.transport.action.admin.cluster.ping.single.ClientTransportSinglePingAction;
import org.elasticsearch.client.transport.action.admin.cluster.state.ClientTransportClusterStateAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalTransportClusterAdminClient
extends AbstractClusterAdminClient
implements InternalClusterAdminClient {
    private final TransportClientNodesService nodesService;
    private final ThreadPool threadPool;
    private final ClientTransportClusterHealthAction clusterHealthAction;
    private final ClientTransportClusterStateAction clusterStateAction;
    private final ClientTransportSinglePingAction singlePingAction;
    private final ClientTransportReplicationPingAction replicationPingAction;
    private final ClientTransportBroadcastPingAction broadcastPingAction;
    private final ClientTransportNodesInfoAction nodesInfoAction;
    private final ClientTransportNodesStatsAction nodesStatsAction;
    private final ClientTransportNodesShutdownAction nodesShutdownAction;
    private final ClientTransportNodesRestartAction nodesRestartAction;

    @Inject
    public InternalTransportClusterAdminClient(Settings settings, TransportClientNodesService nodesService, ThreadPool threadPool, ClientTransportClusterHealthAction clusterHealthAction, ClientTransportClusterStateAction clusterStateAction, ClientTransportSinglePingAction singlePingAction, ClientTransportReplicationPingAction replicationPingAction, ClientTransportBroadcastPingAction broadcastPingAction, ClientTransportNodesInfoAction nodesInfoAction, ClientTransportNodesShutdownAction nodesShutdownAction, ClientTransportNodesRestartAction nodesRestartAction, ClientTransportNodesStatsAction nodesStatsAction) {
        this.nodesService = nodesService;
        this.threadPool = threadPool;
        this.clusterHealthAction = clusterHealthAction;
        this.clusterStateAction = clusterStateAction;
        this.nodesInfoAction = nodesInfoAction;
        this.nodesShutdownAction = nodesShutdownAction;
        this.nodesRestartAction = nodesRestartAction;
        this.singlePingAction = singlePingAction;
        this.replicationPingAction = replicationPingAction;
        this.broadcastPingAction = broadcastPingAction;
        this.nodesStatsAction = nodesStatsAction;
    }

    @Override
    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public ActionFuture<ClusterHealthResponse> health(final ClusterHealthRequest request) {
        return this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<ClusterHealthResponse>>(){

            @Override
            public ActionFuture<ClusterHealthResponse> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return InternalTransportClusterAdminClient.this.clusterHealthAction.execute(node, request);
            }
        });
    }

    @Override
    public void health(final ClusterHealthRequest request, ActionListener<ClusterHealthResponse> listener) {
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<ClusterHealthResponse>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<ClusterHealthResponse> listener) throws ElasticSearchException {
                InternalTransportClusterAdminClient.this.clusterHealthAction.execute(node, request, listener);
            }
        }, listener);
    }

    @Override
    public ActionFuture<ClusterStateResponse> state(final ClusterStateRequest request) {
        return this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<ClusterStateResponse>>(){

            @Override
            public ActionFuture<ClusterStateResponse> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return InternalTransportClusterAdminClient.this.clusterStateAction.execute(node, request);
            }
        });
    }

    @Override
    public void state(final ClusterStateRequest request, ActionListener<ClusterStateResponse> listener) {
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<ClusterStateResponse>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<ClusterStateResponse> listener) throws ElasticSearchException {
                InternalTransportClusterAdminClient.this.clusterStateAction.execute(node, request, listener);
            }
        }, listener);
    }

    @Override
    public ActionFuture<SinglePingResponse> ping(final SinglePingRequest request) {
        return this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<SinglePingResponse>>(){

            @Override
            public ActionFuture<SinglePingResponse> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return InternalTransportClusterAdminClient.this.singlePingAction.execute(node, request);
            }
        });
    }

    @Override
    public void ping(final SinglePingRequest request, ActionListener<SinglePingResponse> listener) {
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<SinglePingResponse>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<SinglePingResponse> listener) throws ElasticSearchException {
                InternalTransportClusterAdminClient.this.singlePingAction.execute(node, request, listener);
            }
        }, listener);
    }

    @Override
    public ActionFuture<BroadcastPingResponse> ping(final BroadcastPingRequest request) {
        return this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<BroadcastPingResponse>>(){

            @Override
            public ActionFuture<BroadcastPingResponse> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return InternalTransportClusterAdminClient.this.broadcastPingAction.execute(node, request);
            }
        });
    }

    @Override
    public void ping(final BroadcastPingRequest request, ActionListener<BroadcastPingResponse> listener) {
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<BroadcastPingResponse>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<BroadcastPingResponse> listener) throws ElasticSearchException {
                InternalTransportClusterAdminClient.this.broadcastPingAction.execute(node, request, listener);
            }
        }, listener);
    }

    @Override
    public ActionFuture<ReplicationPingResponse> ping(final ReplicationPingRequest request) {
        return this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<ReplicationPingResponse>>(){

            @Override
            public ActionFuture<ReplicationPingResponse> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return InternalTransportClusterAdminClient.this.replicationPingAction.execute(node, request);
            }
        });
    }

    @Override
    public void ping(final ReplicationPingRequest request, ActionListener<ReplicationPingResponse> listener) {
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<ReplicationPingResponse>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<ReplicationPingResponse> listener) throws ElasticSearchException {
                InternalTransportClusterAdminClient.this.replicationPingAction.execute(node, request, listener);
            }
        }, listener);
    }

    @Override
    public ActionFuture<NodesInfoResponse> nodesInfo(final NodesInfoRequest request) {
        return this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<NodesInfoResponse>>(){

            @Override
            public ActionFuture<NodesInfoResponse> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return InternalTransportClusterAdminClient.this.nodesInfoAction.execute(node, request);
            }
        });
    }

    @Override
    public void nodesInfo(final NodesInfoRequest request, ActionListener<NodesInfoResponse> listener) {
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<NodesInfoResponse>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<NodesInfoResponse> listener) throws ElasticSearchException {
                InternalTransportClusterAdminClient.this.nodesInfoAction.execute(node, request, listener);
            }
        }, listener);
    }

    @Override
    public ActionFuture<NodesStatsResponse> nodesStats(final NodesStatsRequest request) {
        return this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<NodesStatsResponse>>(){

            @Override
            public ActionFuture<NodesStatsResponse> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return InternalTransportClusterAdminClient.this.nodesStatsAction.execute(node, request);
            }
        });
    }

    @Override
    public void nodesStats(final NodesStatsRequest request, ActionListener<NodesStatsResponse> listener) {
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<NodesStatsResponse>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<NodesStatsResponse> listener) throws ElasticSearchException {
                InternalTransportClusterAdminClient.this.nodesStatsAction.execute(node, request, listener);
            }
        }, listener);
    }

    @Override
    public ActionFuture<NodesShutdownResponse> nodesShutdown(final NodesShutdownRequest request) {
        return this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<NodesShutdownResponse>>(){

            @Override
            public ActionFuture<NodesShutdownResponse> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return InternalTransportClusterAdminClient.this.nodesShutdownAction.execute(node, request);
            }
        });
    }

    @Override
    public void nodesShutdown(final NodesShutdownRequest request, ActionListener<NodesShutdownResponse> listener) {
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<NodesShutdownResponse>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<NodesShutdownResponse> listener) throws ElasticSearchException {
                InternalTransportClusterAdminClient.this.nodesShutdownAction.execute(node, request, listener);
            }
        }, listener);
    }

    @Override
    public ActionFuture<NodesRestartResponse> nodesRestart(final NodesRestartRequest request) {
        return this.nodesService.execute(new TransportClientNodesService.NodeCallback<ActionFuture<NodesRestartResponse>>(){

            @Override
            public ActionFuture<NodesRestartResponse> doWithNode(DiscoveryNode node) throws ElasticSearchException {
                return InternalTransportClusterAdminClient.this.nodesRestartAction.execute(node, request);
            }
        });
    }

    @Override
    public void nodesRestart(final NodesRestartRequest request, ActionListener<NodesRestartResponse> listener) {
        this.nodesService.execute(new TransportClientNodesService.NodeListenerCallback<NodesRestartResponse>(){

            @Override
            public void doWithNode(DiscoveryNode node, ActionListener<NodesRestartResponse> listener) throws ElasticSearchException {
                InternalTransportClusterAdminClient.this.nodesRestartAction.execute(node, request, listener);
            }
        }, listener);
    }
}

