/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardsAllocation;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataDeleteIndexService
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final ShardsAllocation shardsAllocation;
    private final NodeIndexDeletedAction nodeIndexDeletedAction;

    @Inject
    public MetaDataDeleteIndexService(Settings settings, ThreadPool threadPool, ClusterService clusterService, ShardsAllocation shardsAllocation, NodeIndexDeletedAction nodeIndexDeletedAction) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.shardsAllocation = shardsAllocation;
        this.nodeIndexDeletedAction = nodeIndexDeletedAction;
    }

    public void deleteIndex(final Request request, final Listener userListener) {
        this.clusterService.submitStateUpdateTask("delete-index [" + request.index + "]", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                final DeleteIndexListener listener = new DeleteIndexListener(request, userListener);
                try {
                    if (!currentState.metaData().hasConcreteIndex(request.index)) {
                        listener.onFailure(new IndexMissingException(new Index(request.index)));
                        return currentState;
                    }
                    MetaDataDeleteIndexService.this.logger.info("[{}] deleting index", request.index);
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder().routingTable(currentState.routingTable());
                    routingTableBuilder.remove(request.index);
                    MetaData newMetaData = MetaData.newMetaDataBuilder().metaData(currentState.metaData()).remove(request.index).build();
                    RoutingAllocation.Result routingResult = MetaDataDeleteIndexService.this.shardsAllocation.reroute(ClusterState.newClusterStateBuilder().state(currentState).routingTable(routingTableBuilder).metaData(newMetaData).build());
                    ClusterBlocks blocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeIndexBlocks(request.index).build();
                    final AtomicInteger counter = new AtomicInteger(currentState.nodes().size());
                    final NodeIndexDeletedAction.Listener nodeIndexDeleteListener = new NodeIndexDeletedAction.Listener(){

                        @Override
                        public void onNodeIndexDeleted(String index, String nodeId) {
                            if (index.equals(request.index) && counter.decrementAndGet() == 0) {
                                listener.onResponse(new Response(true));
                                MetaDataDeleteIndexService.this.nodeIndexDeletedAction.remove(this);
                            }
                        }
                    };
                    MetaDataDeleteIndexService.this.nodeIndexDeletedAction.add(nodeIndexDeleteListener);
                    listener.future = MetaDataDeleteIndexService.this.threadPool.schedule(request.timeout, "same", new Runnable(){

                        @Override
                        public void run() {
                            listener.onResponse(new Response(false));
                            MetaDataDeleteIndexService.this.nodeIndexDeletedAction.remove(nodeIndexDeleteListener);
                        }
                    });
                    return ClusterState.newClusterStateBuilder().state(currentState).routingResult(routingResult).metaData(newMetaData).blocks(blocks).build();
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return currentState;
                }
            }
        });
    }

    public static class Response {
        private final boolean acknowledged;

        public Response(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class Request {
        final String index;
        TimeValue timeout = TimeValue.timeValueSeconds(10L);

        public Request(String index) {
            this.index = index;
        }

        public Request timeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }
    }

    public static interface Listener {
        public void onResponse(Response var1);

        public void onFailure(Throwable var1);
    }

    class DeleteIndexListener
    implements Listener {
        private AtomicBoolean notified = new AtomicBoolean();
        private final Request request;
        private final Listener listener;
        volatile ScheduledFuture future;

        private DeleteIndexListener(Request request, Listener listener) {
            this.request = request;
            this.listener = listener;
        }

        @Override
        public void onResponse(Response response) {
            if (this.notified.compareAndSet(false, true)) {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.listener.onResponse(response);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            if (this.notified.compareAndSet(false, true)) {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.listener.onFailure(t);
            }
        }
    }
}

