/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.action.index.NodeMappingCreatedAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidTypeNameException;

public class MetaDataMappingService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final NodeMappingCreatedAction mappingCreatedAction;

    @Inject
    public MetaDataMappingService(Settings settings, ClusterService clusterService, IndicesService indicesService, NodeMappingCreatedAction mappingCreatedAction) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.mappingCreatedAction = mappingCreatedAction;
    }

    public void refreshMapping(final String index, final String ... types) {
        this.clusterService.submitStateUpdateTask("refresh-mapping [" + index + "][" + Arrays.toString(types) + "]", new ClusterStateUpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean createdIndex = false;
                try {
                    IndexMetaData indexMetaData = currentState.metaData().index(index);
                    if (indexMetaData == null) {
                        ClusterState clusterState = currentState;
                        return clusterState;
                    }
                    IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index);
                    if (indexService == null) {
                        void var7_11;
                        indexService = MetaDataMappingService.this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), currentState.nodes().localNode().id());
                        createdIndex = true;
                        String[] arr$ = types;
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var7_11 < len$) {
                            String type = arr$[var7_11];
                            if (indexMetaData.mappings().containsKey(type)) {
                                indexService.mapperService().add(type, indexMetaData.mappings().get(type).source().string());
                            }
                            ++var7_11;
                        }
                    }
                    IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.newIndexMetaDataBuilder(indexMetaData);
                    ArrayList<String> updatedTypes = Lists.newArrayList();
                    for (String type : types) {
                        DocumentMapper mapper = indexService.mapperService().documentMapper(type);
                        if (mapper.mappingSource().equals(indexMetaData.mappings().get(type).source())) continue;
                        updatedTypes.add(type);
                        indexMetaDataBuilder.putMapping(new MappingMetaData(mapper));
                    }
                    if (updatedTypes.isEmpty()) {
                        ClusterState clusterState = currentState;
                        return clusterState;
                    }
                    MetaDataMappingService.this.logger.warn("[{}] re-syncing mappings with cluster state for types [{}]", index, updatedTypes);
                    MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    builder.put(indexMetaDataBuilder);
                    ClusterState clusterState = ClusterState.newClusterStateBuilder().state(currentState).metaData(builder).build();
                    return clusterState;
                }
                catch (Exception e) {
                    MetaDataMappingService.this.logger.warn("failed to dynamically refresh the mapping in cluster_state from shard", e, new Object[0]);
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
                finally {
                    if (createdIndex) {
                        MetaDataMappingService.this.indicesService.cleanIndex(index, "created for mapping processing");
                    }
                }
            }
        });
    }

    public void updateMapping(final String index, final String type, final CompressedString mappingSource, final Listener listener) {
        this.clusterService.submitStateUpdateTask("update-mapping [" + index + "][" + type + "]", new ProcessedClusterStateUpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean createdIndex = false;
                try {
                    IndexMetaData indexMetaData = currentState.metaData().index(index);
                    if (indexMetaData == null) {
                        ClusterState clusterState = currentState;
                        return clusterState;
                    }
                    if (indexMetaData.mappings().containsKey(type) && indexMetaData.mapping(type).source().equals(mappingSource)) {
                        ClusterState clusterState = currentState;
                        return clusterState;
                    }
                    IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index);
                    if (indexService == null) {
                        indexService = MetaDataMappingService.this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), currentState.nodes().localNode().id());
                        createdIndex = true;
                        if (indexMetaData.mappings().containsKey(type)) {
                            indexService.mapperService().add(type, indexMetaData.mappings().get(type).source().string());
                        }
                    }
                    MapperService mapperService = indexService.mapperService();
                    DocumentMapper existingMapper = mapperService.documentMapper(type);
                    DocumentMapper updatedMapper = mapperService.parse(type, mappingSource.string());
                    if (existingMapper == null) {
                        existingMapper = updatedMapper;
                    } else {
                        existingMapper.merge(updatedMapper, DocumentMapper.MergeFlags.mergeFlags().simulate(false));
                    }
                    if (indexMetaData.mappings().containsKey(type) && indexMetaData.mapping(type).source().equals(existingMapper.mappingSource())) {
                        ClusterState clusterState = currentState;
                        return clusterState;
                    }
                    if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                        try {
                            MetaDataMappingService.this.logger.debug("[{}] update_mapping [{}] (dynamic) with source [{}]", index, type, existingMapper.mappingSource().string());
                        }
                        catch (IOException e) {}
                    } else if (MetaDataMappingService.this.logger.isInfoEnabled()) {
                        MetaDataMappingService.this.logger.info("[{}] update_mapping [{}] (dynamic)", index, type);
                    }
                    MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    builder.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).putMapping(new MappingMetaData(existingMapper)));
                    ClusterState clusterState = ClusterState.newClusterStateBuilder().state(currentState).metaData(builder).build();
                    return clusterState;
                }
                catch (Exception e) {
                    MetaDataMappingService.this.logger.warn("failed to dynamically update the mapping in cluster_state from shard", e, new Object[0]);
                    listener.onFailure(e);
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
                finally {
                    if (createdIndex) {
                        MetaDataMappingService.this.indicesService.cleanIndex(index, "created for mapping processing");
                    }
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                listener.onResponse(new Response(true));
            }
        });
    }

    public void removeMapping(final RemoveRequest request) {
        this.clusterService.submitStateUpdateTask("remove-mapping [" + request.mappingType + "]", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (request.indices.length == 0) {
                    throw new IndexMissingException(new Index("_all"));
                }
                MetaDataMappingService.this.logger.info("[{}] remove_mapping [{}]", request.indices, request.mappingType);
                MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                for (String indexName : request.indices) {
                    if (!currentState.metaData().hasIndex(indexName)) continue;
                    builder.put(IndexMetaData.newIndexMetaDataBuilder(currentState.metaData().index(indexName)).removeMapping(request.mappingType));
                }
                return ClusterState.builder().state(currentState).metaData(builder).build();
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
            }
        });
    }

    public void putMapping(final PutRequest request, final Listener listener) {
        this.clusterService.submitStateUpdateTask("put-mapping [" + request.mappingType + "]", new ProcessedClusterStateUpdateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                ArrayList<String> indicesToClose = Lists.newArrayList();
                try {
                    ClusterState clusterState;
                    DocumentMapper existingMapper;
                    DocumentMapper newMapper;
                    if (request.indices.length == 0) {
                        throw new IndexMissingException(new Index("_all"));
                    }
                    for (String index : request.indices) {
                        if (currentState.metaData().hasIndex(index)) continue;
                        listener.onFailure(new IndexMissingException(new Index(index)));
                    }
                    for (String index : request.indices) {
                        if (MetaDataMappingService.this.indicesService.hasIndex(index)) continue;
                        IndexMetaData indexMetaData = currentState.metaData().index(index);
                        IndexService indexService = MetaDataMappingService.this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), currentState.nodes().localNode().id());
                        indicesToClose.add(indexMetaData.index());
                        if (!indexMetaData.mappings().containsKey(request.mappingType)) continue;
                        indexService.mapperService().add(request.mappingType, indexMetaData.mappings().get(request.mappingType).source().string());
                    }
                    HashMap<String, DocumentMapper> newMappers = Maps.newHashMap();
                    HashMap<String, DocumentMapper> existingMappers = Maps.newHashMap();
                    for (String index : request.indices) {
                        IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index);
                        if (indexService != null) {
                            newMapper = indexService.mapperService().parse(request.mappingType, request.mappingSource);
                            newMappers.put(index, newMapper);
                            existingMapper = indexService.mapperService().documentMapper(request.mappingType);
                            if (existingMapper == null) continue;
                            DocumentMapper.MergeResult mergeResult = existingMapper.merge(newMapper, DocumentMapper.MergeFlags.mergeFlags().simulate(true));
                            if (!request.ignoreConflicts && mergeResult.hasConflicts()) {
                                throw new MergeMappingException(mergeResult.conflicts());
                            }
                            existingMappers.put(index, existingMapper);
                            continue;
                        }
                        throw new IndexMissingException(new Index(index));
                    }
                    String mappingType = request.mappingType;
                    if (mappingType == null) {
                        mappingType = ((DocumentMapper)newMappers.values().iterator().next()).type();
                    } else if (!mappingType.equals(((DocumentMapper)newMappers.values().iterator().next()).type())) {
                        throw new InvalidTypeNameException("Type name provided does not match type name within mapping definition");
                    }
                    if (!"_default_".equals(mappingType) && mappingType.charAt(0) == '_') {
                        throw new InvalidTypeNameException("Document mapping type name can't start with '_'");
                    }
                    HashMap<String, MappingMetaData> mappings = Maps.newHashMap();
                    for (Map.Entry entry : newMappers.entrySet()) {
                        String index = (String)entry.getKey();
                        newMapper = (DocumentMapper)entry.getValue();
                        if (existingMappers.containsKey(entry.getKey())) {
                            existingMapper = (DocumentMapper)existingMappers.get(entry.getKey());
                            CompressedString existingSource = existingMapper.mappingSource();
                            existingMapper.merge(newMapper, DocumentMapper.MergeFlags.mergeFlags().simulate(false));
                            CompressedString updatedSource = existingMapper.mappingSource();
                            if (existingSource.equals(updatedSource)) continue;
                            mappings.put(index, new MappingMetaData(existingMapper));
                            if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                                MetaDataMappingService.this.logger.debug("[{}] update_mapping [{}] with source [{}]", index, existingMapper.type(), updatedSource);
                                continue;
                            }
                            if (!MetaDataMappingService.this.logger.isInfoEnabled()) continue;
                            MetaDataMappingService.this.logger.info("[{}] update_mapping [{}]", index, existingMapper.type());
                            continue;
                        }
                        CompressedString newSource = newMapper.mappingSource();
                        mappings.put(index, new MappingMetaData(newMapper));
                        if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                            MetaDataMappingService.this.logger.debug("[{}] create_mapping [{}] with source [{}]", index, newMapper.type(), newSource);
                            continue;
                        }
                        if (!MetaDataMappingService.this.logger.isInfoEnabled()) continue;
                        MetaDataMappingService.this.logger.info("[{}] create_mapping [{}]", index, newMapper.type());
                    }
                    if (mappings.isEmpty()) {
                        listener.onResponse(new Response(true));
                        ClusterState i$ = currentState;
                        return i$;
                    }
                    MetaData.Builder builder = MetaData.newMetaDataBuilder().metaData(currentState.metaData());
                    for (String indexName : request.indices) {
                        IndexMetaData indexMetaData = currentState.metaData().index(indexName);
                        if (indexMetaData == null) {
                            throw new IndexMissingException(new Index(indexName));
                        }
                        MappingMetaData mappingMd = (MappingMetaData)mappings.get(indexName);
                        if (mappingMd == null) continue;
                        builder.put(IndexMetaData.newIndexMetaDataBuilder(indexMetaData).putMapping(mappingMd));
                    }
                    ClusterState updatedState = ClusterState.newClusterStateBuilder().state(currentState).metaData(builder).build();
                    int counter = 0;
                    for (String index : request.indices) {
                        IndexRoutingTable indexRoutingTable = updatedState.routingTable().index(index);
                        if (indexRoutingTable == null) continue;
                        counter += indexRoutingTable.numberOfNodesShardsAreAllocatedOn(updatedState.nodes().masterNodeId());
                    }
                    if (counter == 0) {
                        listener.onResponse(new Response(true));
                        clusterState = updatedState;
                        return clusterState;
                    }
                    MetaDataMappingService.this.mappingCreatedAction.add(new CountDownListener(counter, listener), request.timeout);
                    clusterState = updatedState;
                    return clusterState;
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
                finally {
                    for (String index : indicesToClose) {
                        MetaDataMappingService.this.indicesService.cleanIndex(index, "created for mapping processing");
                    }
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
            }
        });
    }

    private class CountDownListener
    implements NodeMappingCreatedAction.Listener {
        private final AtomicBoolean notified = new AtomicBoolean();
        private final AtomicInteger countDown;
        private final Listener listener;

        public CountDownListener(int countDown, Listener listener) {
            this.countDown = new AtomicInteger(countDown);
            this.listener = listener;
        }

        @Override
        public void onNodeMappingCreated(NodeMappingCreatedAction.NodeMappingCreatedResponse response) {
            if (this.countDown.decrementAndGet() == 0) {
                MetaDataMappingService.this.mappingCreatedAction.remove(this);
                if (this.notified.compareAndSet(false, true)) {
                    this.listener.onResponse(new Response(true));
                }
            }
        }

        @Override
        public void onTimeout() {
            MetaDataMappingService.this.mappingCreatedAction.remove(this);
            if (this.notified.compareAndSet(false, true)) {
                this.listener.onResponse(new Response(false));
            }
        }
    }

    public static class Response {
        private final boolean acknowledged;

        public Response(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class PutRequest {
        final String[] indices;
        final String mappingType;
        final String mappingSource;
        boolean ignoreConflicts = false;
        TimeValue timeout = TimeValue.timeValueSeconds(10L);

        public PutRequest(String[] indices, String mappingType, String mappingSource) {
            this.indices = indices;
            this.mappingType = mappingType;
            this.mappingSource = mappingSource;
        }

        public PutRequest ignoreConflicts(boolean ignoreConflicts) {
            this.ignoreConflicts = ignoreConflicts;
            return this;
        }

        public PutRequest timeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }
    }

    public static class RemoveRequest {
        final String[] indices;
        final String mappingType;

        public RemoveRequest(String[] indices, String mappingType) {
            this.indices = indices;
            this.mappingType = mappingType;
        }
    }

    public static interface Listener {
        public void onResponse(Response var1);

        public void onFailure(Throwable var1);
    }
}

