/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.transport.TransportAddressSerializers;

public class DiscoveryNode
implements Streamable,
Serializable {
    public static final ImmutableList<DiscoveryNode> EMPTY_LIST = ImmutableList.of();
    private String nodeName = "".intern();
    private String nodeId;
    private TransportAddress address;
    private ImmutableMap<String, String> attributes;

    public static boolean nodeRequiresLocalStorage(Settings settings) {
        return settings.getAsBoolean("node.client", false) == false && (settings.getAsBoolean("node.data", true) != false || settings.getAsBoolean("node.master", true) != false);
    }

    public static Map<String, String> buildCommonNodesAttributes(Settings settings) {
        HashMap<String, String> attributes = Maps.newHashMap(settings.getByPrefix("node.").getAsMap());
        attributes.remove("name");
        if (attributes.containsKey("client")) {
            if (((String)attributes.get("client")).equals("false")) {
                attributes.remove("client");
            } else {
                attributes.put("data", "false");
            }
        }
        if (attributes.containsKey("data") && ((String)attributes.get("data")).equals("true")) {
            attributes.remove("data");
        }
        return attributes;
    }

    private DiscoveryNode() {
    }

    public DiscoveryNode(String nodeId, TransportAddress address) {
        this("", nodeId, address, ImmutableMap.of());
    }

    public DiscoveryNode(String nodeName, String nodeId, TransportAddress address, Map<String, String> attributes) {
        this.nodeName = nodeName == null ? "".intern() : nodeName.intern();
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            builder.put(entry.getKey().intern(), entry.getValue().intern());
        }
        this.attributes = builder.build();
        this.nodeId = nodeId.intern();
        this.address = address;
    }

    public boolean shouldConnectTo(DiscoveryNode otherNode) {
        return !this.clientNode() || !otherNode.clientNode();
    }

    public TransportAddress address() {
        return this.address;
    }

    public TransportAddress getAddress() {
        return this.address();
    }

    public String id() {
        return this.nodeId;
    }

    public String getId() {
        return this.id();
    }

    public String name() {
        return this.nodeName;
    }

    public String getName() {
        return this.name();
    }

    public ImmutableMap<String, String> attributes() {
        return this.attributes;
    }

    public ImmutableMap<String, String> getAttributes() {
        return this.attributes();
    }

    public boolean dataNode() {
        String data = this.attributes.get("data");
        if (data == null) {
            return !this.clientNode();
        }
        return data.equals("true");
    }

    public boolean isDataNode() {
        return this.dataNode();
    }

    public boolean clientNode() {
        String client = this.attributes.get("client");
        return client != null && client.equals("true");
    }

    public boolean isClientNode() {
        return this.clientNode();
    }

    public boolean masterNode() {
        String master = this.attributes.get("master");
        if (master == null) {
            return !this.clientNode();
        }
        return master.equals("true");
    }

    public boolean isMasterNode() {
        return this.masterNode();
    }

    public static DiscoveryNode readNode(StreamInput in) throws IOException {
        DiscoveryNode node = new DiscoveryNode();
        node.readFrom(in);
        return node;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.nodeName = in.readUTF().intern();
        this.nodeId = in.readUTF().intern();
        this.address = TransportAddressSerializers.addressFromStream(in);
        int size = in.readVInt();
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            builder.put(in.readUTF().intern(), in.readUTF().intern());
        }
        this.attributes = builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.nodeName);
        out.writeUTF(this.nodeId);
        TransportAddressSerializers.addressToStream(out, this.address);
        out.writeVInt(this.attributes.size());
        for (Map.Entry entry : this.attributes.entrySet()) {
            out.writeUTF((String)entry.getKey());
            out.writeUTF((String)entry.getValue());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DiscoveryNode)) {
            return false;
        }
        DiscoveryNode other = (DiscoveryNode)obj;
        return this.nodeId.equals(other.nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nodeName.length() > 0) {
            sb.append('[').append(this.nodeName).append(']');
        }
        if (this.nodeId != null) {
            sb.append('[').append(this.nodeId).append(']');
        }
        if (this.address != null) {
            sb.append('[').append(this.address).append(']');
        }
        if (!this.attributes.isEmpty()) {
            sb.append(this.attributes);
        }
        return sb.toString();
    }
}

