/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.operation.plain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.operation.OperationRouting;
import org.elasticsearch.cluster.routing.operation.hash.HashFunction;
import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexMissingException;

public class PlainOperationRouting
extends AbstractComponent
implements OperationRouting {
    private final HashFunction hashFunction;
    private final boolean useType;

    @Inject
    public PlainOperationRouting(Settings indexSettings, HashFunction hashFunction) {
        super(indexSettings);
        this.hashFunction = hashFunction;
        this.useType = indexSettings.getAsBoolean("cluster.routing.operation.use_type", false);
    }

    @Override
    public ShardIterator indexShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing) throws IndexMissingException, IndexShardMissingException {
        return this.shards(clusterState, index, type, id, routing).shardsIt();
    }

    @Override
    public ShardIterator deleteShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing) throws IndexMissingException, IndexShardMissingException {
        return this.shards(clusterState, index, type, id, routing).shardsIt();
    }

    @Override
    public ShardIterator getShards(ClusterState clusterState, String index, String type, String id, @Nullable String routing, @Nullable String preference) throws IndexMissingException, IndexShardMissingException {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index, type, id, routing), clusterState.nodes().localNodeId(), preference);
    }

    @Override
    public ShardIterator getShards(ClusterState clusterState, String index, int shardId, @Nullable String preference) throws IndexMissingException, IndexShardMissingException {
        return this.preferenceActiveShardIterator(this.shards(clusterState, index, shardId), clusterState.nodes().localNodeId(), preference);
    }

    @Override
    public GroupShardsIterator broadcastDeleteShards(ClusterState clusterState, String index) throws IndexMissingException {
        return this.indexRoutingTable(clusterState, index).groupByShardsIt();
    }

    @Override
    public GroupShardsIterator deleteByQueryShards(ClusterState clusterState, String index, @Nullable Set<String> routing) throws IndexMissingException {
        if (routing == null || routing.isEmpty()) {
            return this.indexRoutingTable(clusterState, index).groupByShardsIt();
        }
        HashSet<ShardIterator> set = new HashSet<ShardIterator>();
        IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
        for (String r : routing) {
            int shardId = this.shardId(clusterState, index, null, null, r);
            IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
            if (indexShard == null) {
                throw new IndexShardMissingException(new ShardId(index, shardId));
            }
            set.add(indexShard.shardsRandomIt());
        }
        return new GroupShardsIterator(set);
    }

    @Override
    public int searchShardsCount(ClusterState clusterState, String[] indices, String[] concreteIndices, @Nullable String queryHint, @Nullable Map<String, Set<String>> routing, @Nullable String preference) throws IndexMissingException {
        if (concreteIndices == null || concreteIndices.length == 0) {
            concreteIndices = clusterState.metaData().concreteAllOpenIndices();
        }
        if (routing != null) {
            HashSet<ShardId> set = new HashSet<ShardId>();
            for (String index : concreteIndices) {
                IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
                Set<String> effectiveRouting = routing.get(index);
                if (effectiveRouting == null) continue;
                for (String r : effectiveRouting) {
                    int shardId = this.shardId(clusterState, index, null, null, r);
                    IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
                    if (indexShard == null) {
                        throw new IndexShardMissingException(new ShardId(index, shardId));
                    }
                    set.add(indexShard.shardId());
                }
            }
            return set.size();
        }
        int count = 0;
        for (String index : concreteIndices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
            count += indexRouting.shards().size();
        }
        return count;
    }

    @Override
    public GroupShardsIterator searchShards(ClusterState clusterState, String[] indices, String[] concreteIndices, @Nullable String queryHint, @Nullable Map<String, Set<String>> routing, @Nullable String preference) throws IndexMissingException {
        if (concreteIndices == null || concreteIndices.length == 0) {
            concreteIndices = clusterState.metaData().concreteAllOpenIndices();
        }
        if (routing != null) {
            HashSet<ShardIterator> set = new HashSet<ShardIterator>();
            for (String index : concreteIndices) {
                IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
                Set<String> effectiveRouting = routing.get(index);
                if (effectiveRouting == null) continue;
                for (String r : effectiveRouting) {
                    int shardId = this.shardId(clusterState, index, null, null, r);
                    IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
                    if (indexShard == null) {
                        throw new IndexShardMissingException(new ShardId(index, shardId));
                    }
                    set.add(this.preferenceActiveShardIterator(indexShard, clusterState.nodes().localNodeId(), preference));
                }
            }
            return new GroupShardsIterator(set);
        }
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRouting = this.indexRoutingTable(clusterState, index);
            for (IndexShardRoutingTable indexShard : indexRouting) {
                set.add(this.preferenceActiveShardIterator(indexShard, clusterState.nodes().localNodeId(), preference));
            }
        }
        return new GroupShardsIterator(set);
    }

    private ShardIterator preferenceActiveShardIterator(IndexShardRoutingTable indexShard, String nodeId, @Nullable String preference) {
        if (preference == null) {
            return indexShard.activeShardsRandomIt();
        }
        if ("_local".equals(preference)) {
            return indexShard.preferNodeShardsIt(nodeId);
        }
        if ("_primary".equals(preference)) {
            return indexShard.primaryShardIt();
        }
        return indexShard.shardsIt(DjbHashFunction.DJB_HASH(preference));
    }

    public IndexMetaData indexMetaData(ClusterState clusterState, String index) {
        IndexMetaData indexMetaData = clusterState.metaData().index(index);
        if (indexMetaData == null) {
            throw new IndexMissingException(new Index(index));
        }
        return indexMetaData;
    }

    protected IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index);
        if (indexRouting == null) {
            throw new IndexMissingException(new Index(index));
        }
        return indexRouting;
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index, String type, String id, String routing) {
        int shardId = this.shardId(clusterState, index, type, id, routing);
        return this.shards(clusterState, index, shardId);
    }

    protected IndexShardRoutingTable shards(ClusterState clusterState, String index, int shardId) {
        IndexShardRoutingTable indexShard = this.indexRoutingTable(clusterState, index).shard(shardId);
        if (indexShard == null) {
            throw new IndexShardMissingException(new ShardId(index, shardId));
        }
        return indexShard;
    }

    private int shardId(ClusterState clusterState, String index, String type, @Nullable String id, @Nullable String routing) {
        if (routing == null) {
            if (!this.useType) {
                return Math.abs(this.hash(id)) % this.indexMetaData(clusterState, index).numberOfShards();
            }
            return Math.abs(this.hash(type, id)) % this.indexMetaData(clusterState, index).numberOfShards();
        }
        return Math.abs(this.hash(routing)) % this.indexMetaData(clusterState, index).numberOfShards();
    }

    protected int hash(String routing) {
        return this.hashFunction.hash(routing);
    }

    protected int hash(String type, String id) {
        if (type == null || "_all".equals(type)) {
            throw new ElasticSearchIllegalArgumentException("Can't route an operation with no type and having type part of the routing (for backward comp)");
        }
        return this.hashFunction.hash(type, id);
    }
}

