/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.operation.OperationRouting;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class InternalClusterService
extends AbstractLifecycleComponent<ClusterService>
implements ClusterService {
    private final ThreadPool threadPool;
    private final DiscoveryService discoveryService;
    private final OperationRouting operationRouting;
    private final TransportService transportService;
    private final TimeValue reconnectInterval;
    private volatile ExecutorService updateTasksExecutor;
    private final List<ClusterStateListener> priorityClusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final List<ClusterStateListener> clusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Queue<NotifyTimeout> onGoingTimeouts = new LinkedTransferQueue<NotifyTimeout>();
    private volatile ClusterState clusterState = ClusterState.newClusterStateBuilder().build();
    private final ClusterBlocks.Builder initialBlocks = ClusterBlocks.builder().addGlobalBlock(Discovery.NO_MASTER_BLOCK);
    private volatile ScheduledFuture reconnectToNodes;

    @Inject
    public InternalClusterService(Settings settings, DiscoveryService discoveryService, OperationRouting operationRouting, TransportService transportService, ThreadPool threadPool) {
        super(settings);
        this.operationRouting = operationRouting;
        this.transportService = transportService;
        this.discoveryService = discoveryService;
        this.threadPool = threadPool;
        this.reconnectInterval = this.componentSettings.getAsTime("reconnect_interval", TimeValue.timeValueSeconds(10L));
    }

    @Override
    public void addInitialStateBlock(ClusterBlock block) throws ElasticSearchIllegalStateException {
        if (this.lifecycle.started()) {
            throw new ElasticSearchIllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.addGlobalBlock(block);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.clusterState = ClusterState.newClusterStateBuilder().blocks(this.initialBlocks).build();
        this.updateTasksExecutor = Executors.newSingleThreadExecutor(EsExecutors.daemonThreadFactory(this.settings, "clusterService#updateTask"));
        this.reconnectToNodes = this.threadPool.schedule(this.reconnectInterval, "cached", new ReconnectToNodes());
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.reconnectToNodes.cancel(true);
        for (NotifyTimeout onGoingTimeout : this.onGoingTimeouts) {
            onGoingTimeout.cancel();
            onGoingTimeout.listener.onClose();
        }
        this.updateTasksExecutor.shutdown();
        try {
            this.updateTasksExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    @Override
    public DiscoveryNode localNode() {
        return this.discoveryService.localNode();
    }

    @Override
    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    @Override
    public ClusterState state() {
        return this.clusterState;
    }

    @Override
    public void addPriority(ClusterStateListener listener) {
        this.priorityClusterStateListeners.add(listener);
    }

    @Override
    public void add(ClusterStateListener listener) {
        this.clusterStateListeners.add(listener);
    }

    @Override
    public void remove(ClusterStateListener listener) {
        this.clusterStateListeners.remove(listener);
        Iterator it = this.onGoingTimeouts.iterator();
        while (it.hasNext()) {
            NotifyTimeout timeout = (NotifyTimeout)it.next();
            if (!timeout.listener.equals(listener)) continue;
            timeout.cancel();
            it.remove();
        }
    }

    @Override
    public void add(TimeValue timeout, final TimeoutClusterStateListener listener) {
        if (this.lifecycle.stoppedOrClosed()) {
            listener.onClose();
            return;
        }
        NotifyTimeout notifyTimeout = new NotifyTimeout(listener, timeout);
        notifyTimeout.future = this.threadPool.schedule(timeout, "cached", notifyTimeout);
        this.onGoingTimeouts.add(notifyTimeout);
        this.clusterStateListeners.add(listener);
        this.updateTasksExecutor.execute(new Runnable(){

            @Override
            public void run() {
                listener.postAdded();
            }
        });
    }

    @Override
    public void submitStateUpdateTask(final String source, final ClusterStateUpdateTask updateTask) {
        if (!this.lifecycle.started()) {
            return;
        }
        this.updateTasksExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!InternalClusterService.this.lifecycle.started()) {
                    InternalClusterService.this.logger.debug("processing [{}]: ignoring, cluster_service not started", source);
                    return;
                }
                InternalClusterService.this.logger.debug("processing [{}]: execute", source);
                ClusterState previousClusterState = InternalClusterService.this.clusterState;
                try {
                    InternalClusterService.this.clusterState = updateTask.execute(previousClusterState);
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder("failed to execute cluster state update, state:\nversion [").append(InternalClusterService.this.clusterState.version()).append("], source [").append(source).append("]\n");
                    sb.append(InternalClusterService.this.clusterState.nodes().prettyPrint());
                    sb.append(InternalClusterService.this.clusterState.routingTable().prettyPrint());
                    sb.append(InternalClusterService.this.clusterState.readOnlyRoutingNodes().prettyPrint());
                    InternalClusterService.this.logger.warn(sb.toString(), e, new Object[0]);
                    return;
                }
                if (previousClusterState != InternalClusterService.this.clusterState) {
                    String summary;
                    if (InternalClusterService.this.clusterState.nodes().localNodeMaster()) {
                        ClusterState.Builder builder = ClusterState.builder().state(InternalClusterService.this.clusterState).version(InternalClusterService.this.clusterState.version() + 1L);
                        if (previousClusterState.routingTable() != InternalClusterService.this.clusterState.routingTable()) {
                            builder.routingTable(RoutingTable.builder().routingTable(InternalClusterService.this.clusterState.routingTable()).version(InternalClusterService.this.clusterState.routingTable().version() + 1L));
                        }
                        if (previousClusterState.metaData() != InternalClusterService.this.clusterState.metaData()) {
                            builder.metaData(MetaData.builder().metaData(InternalClusterService.this.clusterState.metaData()).version(InternalClusterService.this.clusterState.metaData().version() + 1L));
                        }
                        InternalClusterService.this.clusterState = builder.build();
                    } else if (InternalClusterService.this.clusterState.version() < previousClusterState.version()) {
                        InternalClusterService.this.logger.debug("got old cluster state [" + InternalClusterService.this.clusterState.version() + "<" + previousClusterState.version() + "] from source [" + source + "], ignoring", new Object[0]);
                        return;
                    }
                    if (InternalClusterService.this.logger.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder("cluster state updated:\nversion [").append(InternalClusterService.this.clusterState.version()).append("], source [").append(source).append("]\n");
                        sb.append(InternalClusterService.this.clusterState.nodes().prettyPrint());
                        sb.append(InternalClusterService.this.clusterState.routingTable().prettyPrint());
                        sb.append(InternalClusterService.this.clusterState.readOnlyRoutingNodes().prettyPrint());
                        InternalClusterService.this.logger.trace(sb.toString(), new Object[0]);
                    } else if (InternalClusterService.this.logger.isDebugEnabled()) {
                        InternalClusterService.this.logger.debug("cluster state updated, version [{}], source [{}]", InternalClusterService.this.clusterState.version(), source);
                    }
                    ClusterChangedEvent clusterChangedEvent = new ClusterChangedEvent(source, InternalClusterService.this.clusterState, previousClusterState);
                    final DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
                    if (nodesDelta.hasChanges() && InternalClusterService.this.logger.isInfoEnabled() && (summary = nodesDelta.shortSummary()).length() > 0) {
                        InternalClusterService.this.logger.info("{}, reason: {}", summary, source);
                    }
                    for (DiscoveryNode node : nodesDelta.addedNodes()) {
                        if (!InternalClusterService.this.nodeRequiresConnection(node)) continue;
                        try {
                            InternalClusterService.this.transportService.connectToNode(node);
                        }
                        catch (Exception e) {
                            InternalClusterService.this.logger.warn("failed to connect to node [" + node + "]", e, new Object[0]);
                        }
                    }
                    for (ClusterStateListener listener : InternalClusterService.this.priorityClusterStateListeners) {
                        listener.clusterChanged(clusterChangedEvent);
                    }
                    for (ClusterStateListener listener : InternalClusterService.this.clusterStateListeners) {
                        listener.clusterChanged(clusterChangedEvent);
                    }
                    if (!nodesDelta.removedNodes().isEmpty()) {
                        InternalClusterService.this.threadPool.cached().execute(new Runnable(){

                            @Override
                            public void run() {
                                for (DiscoveryNode node : nodesDelta.removedNodes()) {
                                    InternalClusterService.this.transportService.disconnectFromNode(node);
                                }
                            }
                        });
                    }
                    if (InternalClusterService.this.clusterState.nodes().localNodeMaster()) {
                        InternalClusterService.this.discoveryService.publish(InternalClusterService.this.clusterState);
                    }
                    if (updateTask instanceof ProcessedClusterStateUpdateTask) {
                        ((ProcessedClusterStateUpdateTask)updateTask).clusterStateProcessed(InternalClusterService.this.clusterState);
                    }
                    InternalClusterService.this.logger.debug("processing [{}]: done applying updated cluster_state", source);
                } else {
                    InternalClusterService.this.logger.debug("processing [{}]: no change in cluster_state", source);
                }
            }
        });
    }

    private boolean nodeRequiresConnection(DiscoveryNode node) {
        return this.localNode().shouldConnectTo(node);
    }

    private class ReconnectToNodes
    implements Runnable {
        private ReconnectToNodes() {
        }

        @Override
        public void run() {
            for (DiscoveryNode node : InternalClusterService.this.clusterState.nodes()) {
                if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                    return;
                }
                if (!InternalClusterService.this.nodeRequiresConnection(node) || !InternalClusterService.this.clusterState.nodes().nodeExists(node.id()) || InternalClusterService.this.transportService.nodeConnected(node)) continue;
                try {
                    InternalClusterService.this.transportService.connectToNode(node);
                }
                catch (Exception e) {
                    if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                        return;
                    }
                    if (!InternalClusterService.this.clusterState.nodes().nodeExists(node.id())) continue;
                    InternalClusterService.this.logger.warn("failed to reconnect to node {}", e, node);
                }
            }
            if (InternalClusterService.this.lifecycle.started()) {
                InternalClusterService.this.reconnectToNodes = InternalClusterService.this.threadPool.schedule(InternalClusterService.this.reconnectInterval, "cached", this);
            }
        }
    }

    class NotifyTimeout
    implements Runnable {
        final TimeoutClusterStateListener listener;
        final TimeValue timeout;
        ScheduledFuture future;

        NotifyTimeout(TimeoutClusterStateListener listener, TimeValue timeout) {
            this.listener = listener;
            this.timeout = timeout;
        }

        public void cancel() {
            this.future.cancel(false);
        }

        @Override
        public void run() {
            if (this.future.isCancelled()) {
                return;
            }
            if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                this.listener.onClose();
            } else {
                this.listener.onTimeout(this.timeout);
            }
        }
    }
}

