/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class BytesHolder
implements Streamable {
    private byte[] bytes;
    private int offset;
    private int length;

    BytesHolder() {
    }

    public BytesHolder(byte[] bytes) {
        this.bytes = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public BytesHolder(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public byte[] copyBytes() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public static BytesHolder readBytesHolder(StreamInput in) throws IOException {
        BytesHolder holder = new BytesHolder();
        holder.readFrom(in);
        return holder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.offset = 0;
        this.length = in.readVInt();
        this.bytes = new byte[this.length];
        in.readFully(this.bytes);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.length);
        out.writeBytes(this.bytes, this.offset, this.length);
    }

    public boolean equals(Object obj) {
        return this.bytesEquals((BytesHolder)obj);
    }

    public boolean bytesEquals(BytesHolder other) {
        if (this.length == other.length) {
            int otherUpto = other.offset;
            byte[] otherBytes = other.bytes;
            int end = this.offset + this.length;
            int upto = this.offset;
            while (upto < end) {
                if (this.bytes[upto] != otherBytes[otherUpto]) {
                    return false;
                }
                ++upto;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            result = 31 * result + this.bytes[i];
        }
        return result;
    }
}

