/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.elasticsearch.common.base.Equivalence;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.AsynchronousComputationException;
import org.elasticsearch.common.collect.ComputationException;
import org.elasticsearch.common.collect.CustomConcurrentHashMap;
import org.elasticsearch.common.collect.MapEvictionListener;
import org.elasticsearch.common.collect.MapMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComputingConcurrentHashMap<K, V>
extends CustomConcurrentHashMap<K, V>
implements MapMaker.Cache<K, V> {
    final Function<? super K, ? extends V> computingFunction;
    private static final long serialVersionUID = 2L;

    ComputingConcurrentHashMap(MapMaker builder, Function<? super K, ? extends V> computingFunction) {
        super(builder);
        this.computingFunction = Preconditions.checkNotNull(computingFunction);
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this;
    }

    @Override
    CustomConcurrentHashMap.Segment createSegment(int initialCapacity, int maxSegmentSize) {
        return new ComputingSegment(initialCapacity, maxSegmentSize);
    }

    @Override
    ComputingSegment segmentFor(int hash) {
        return (ComputingSegment)super.segmentFor(hash);
    }

    @Override
    public V apply(K key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).compute(key, hash);
    }

    @Override
    Object writeReplace() {
        return new ComputingSerializationProxy<K, V>(this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expireAfterWriteNanos, this.expireAfterAccessNanos, this.maximumSize, this.concurrencyLevel, this.evictionListener, this, this.computingFunction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComputingSerializationProxy<K, V>
    extends CustomConcurrentHashMap.AbstractSerializationProxy<K, V> {
        final Function<? super K, ? extends V> computingFunction;
        transient MapMaker.Cache<K, V> cache;
        private static final long serialVersionUID = 2L;

        ComputingSerializationProxy(CustomConcurrentHashMap.Strength keyStrength, CustomConcurrentHashMap.Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expireAfterWriteNanos, long expireAfterAccessNanos, int maximumSize, int concurrencyLevel, MapEvictionListener<? super K, ? super V> evictionListener, ConcurrentMap<K, V> delegate, Function<? super K, ? extends V> computingFunction) {
            super(keyStrength, valueStrength, keyEquivalence, valueEquivalence, expireAfterWriteNanos, expireAfterAccessNanos, maximumSize, concurrencyLevel, evictionListener, delegate);
            this.computingFunction = computingFunction;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            this.writeMapTo(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(in);
            this.cache = mapMaker.makeCache(this.computingFunction);
            this.delegate = this.cache.asMap();
            this.readEntries(in);
        }

        Object readResolve() {
            return this.cache;
        }

        public ConcurrentMap<K, V> asMap() {
            return this.delegate;
        }

        public V apply(@Nullable K from) {
            return (V)this.cache.apply(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComputingValueReference
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        @GuardedBy(value="ComputingValueReference.this")
        CustomConcurrentHashMap.ValueReference<K, V> computedReference = CustomConcurrentHashMap.unset();

        private ComputingValueReference() {
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V waitForValue() throws InterruptedException {
            if (this.computedReference == CustomConcurrentHashMap.UNSET) {
                ComputingValueReference computingValueReference = this;
                synchronized (computingValueReference) {
                    if (this.computedReference == CustomConcurrentHashMap.UNSET) {
                        this.wait();
                    }
                }
            }
            return this.computedReference.waitForValue();
        }

        @Override
        public void clear() {
            this.setValueReference(new ComputedReference(null));
        }

        @Override
        public void notifyValueReclaimed() {
        }

        V compute(K key, int hash) {
            Object value;
            try {
                value = ComputingConcurrentHashMap.this.computingFunction.apply(key);
            }
            catch (ComputationException e) {
                this.setValueReference(new ComputationExceptionReference(e.getCause()));
                throw e;
            }
            catch (Throwable t) {
                this.setValueReference(new ComputationExceptionReference(t));
                throw new ComputationException(t);
            }
            if (value == null) {
                String message = ComputingConcurrentHashMap.this.computingFunction + " returned null for key " + key + ".";
                this.setValueReference(new NullPointerExceptionReference(message));
                throw new NullPointerException(message);
            }
            this.setValueReference(new ComputedReference(value));
            ComputingConcurrentHashMap.this.segmentFor(hash).put(key, hash, value, true);
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setValueReference(CustomConcurrentHashMap.ValueReference<K, V> valueReference) {
            ComputingValueReference computingValueReference = this;
            synchronized (computingValueReference) {
                if (this.computedReference == CustomConcurrentHashMap.UNSET) {
                    this.computedReference = valueReference;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComputedReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final V value;

        ComputedReference(@Nullable V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            return this.get();
        }

        @Override
        public void notifyValueReclaimed() {
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComputationExceptionReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final Throwable t;

        ComputationExceptionReference(Throwable t) {
            this.t = t;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            throw new AsynchronousComputationException(this.t);
        }

        @Override
        public void notifyValueReclaimed() {
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullPointerExceptionReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final String message;

        NullPointerExceptionReference(String message) {
            this.message = message;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public boolean isComputingReference() {
            return false;
        }

        @Override
        public V waitForValue() {
            throw new NullPointerException(this.message);
        }

        @Override
        public void notifyValueReclaimed() {
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComputingSegment
    extends CustomConcurrentHashMap.Segment {
        ComputingSegment(int initialCapacity, int maxSegmentSize) {
            super(ComputingConcurrentHashMap.this, initialCapacity, maxSegmentSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V compute(K key, int hash) {
            Object value;
            block15: while ((value = this.get(key, hash)) == null) {
                Object table;
                CustomConcurrentHashMap.ReferenceEntry entry = null;
                ComputingValueReference computingValueReference = null;
                this.lock();
                try {
                    CustomConcurrentHashMap.ReferenceEntry first;
                    this.preWriteCleanup();
                    table = this.table;
                    int index = hash & ((AtomicReferenceArray)table).length() - 1;
                    for (CustomConcurrentHashMap.ReferenceEntry e = first = (CustomConcurrentHashMap.ReferenceEntry)((AtomicReferenceArray)table).get(index); e != null; e = e.getNext()) {
                        Object entryKey = e.getKey();
                        if (e.getHash() != hash || entryKey == null || !ComputingConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                        if (!e.getValueReference().isComputingReference()) {
                            value = this.getLiveValue(e);
                            if (value != null) {
                                this.recordLockedRead(e);
                                Object v = value;
                                return v;
                            }
                            this.unsetLiveEntry(e, hash);
                        }
                        entry = e;
                        break;
                    }
                    if (entry == null || ComputingConcurrentHashMap.this.isUnset(entry)) {
                        computingValueReference = new ComputingValueReference();
                        if (entry == null) {
                            entry = ComputingConcurrentHashMap.this.newEntry(key, hash, first);
                            ((AtomicReferenceArray)table).set(index, entry);
                        }
                        entry.setValueReference(computingValueReference);
                    }
                }
                finally {
                    this.unlock();
                    this.postWriteCleanup();
                }
                if (computingValueReference != null) {
                    try {
                        table = entry;
                        synchronized (table) {
                            value = computingValueReference.compute(key, hash);
                        }
                        Preconditions.checkNotNull(value, "compute() returned null unexpectedly");
                        table = value;
                        return table;
                    }
                    finally {
                        if (value == null) {
                            this.clearValue(key, hash, computingValueReference);
                        }
                    }
                }
                boolean interrupted = false;
                while (true) {
                    try {
                        Preconditions.checkState(!Thread.holdsLock(entry), "Recursive computation");
                        value = entry.getValueReference().waitForValue();
                        if (value == null) continue block15;
                        this.recordRead(entry);
                        Object index = value;
                        return index;
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            return value;
        }
    }
}

