/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.compress.lzf.BufferRecycler;
import org.elasticsearch.common.compress.lzf.LZFDecoder;

public class LZFInputStream
extends InputStream {
    private final BufferRecycler _recycler = BufferRecycler.instance();
    protected final InputStream inputStream;
    protected boolean inputStreamClosed;
    protected boolean cfgFullReads = false;
    private byte[] _inputBuffer;
    private byte[] _decodedBytes;
    private int bufferPosition = 0;
    private int bufferLength = 0;

    public LZFInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public LZFInputStream(InputStream in, boolean fullReads) throws IOException {
        this.inputStream = in;
        this.inputStreamClosed = false;
        this.cfgFullReads = fullReads;
        this._inputBuffer = this._recycler.allocInputBuffer(65535);
        this._decodedBytes = this._recycler.allocDecodeBuffer(65535);
    }

    @Override
    public int available() {
        if (this.inputStreamClosed) {
            return -1;
        }
        int left = this.bufferLength - this.bufferPosition;
        return left <= 0 ? 0 : left;
    }

    @Override
    public int read() throws IOException {
        if (!this.readyBuffer()) {
            return -1;
        }
        return this._decodedBytes[this.bufferPosition++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        if (!this.readyBuffer()) {
            return -1;
        }
        int chunkLength = Math.min(this.bufferLength - this.bufferPosition, length);
        System.arraycopy(this._decodedBytes, this.bufferPosition, buffer, offset, chunkLength);
        this.bufferPosition += chunkLength;
        if (chunkLength == length || !this.cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this.bufferLength - this.bufferPosition, length - totalRead);
            System.arraycopy(this._decodedBytes, this.bufferPosition, buffer, offset, chunkLength);
            this.bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    @Override
    public void close() throws IOException {
        this.bufferLength = 0;
        this.bufferPosition = 0;
        byte[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._recycler.releaseInputBuffer(buf);
        }
        if ((buf = this._decodedBytes) != null) {
            this._decodedBytes = null;
            this._recycler.releaseDecodeBuffer(buf);
        }
        if (!this.inputStreamClosed) {
            this.inputStreamClosed = true;
            this.inputStream.close();
        }
    }

    public InputStream getUnderlyingInputStream() {
        return this.inputStream;
    }

    protected boolean readyBuffer() throws IOException {
        if (this.bufferPosition < this.bufferLength) {
            return true;
        }
        if (this.inputStreamClosed) {
            return false;
        }
        this.bufferLength = LZFDecoder.decompressChunk(this.inputStream, this._inputBuffer, this._decodedBytes);
        if (this.bufferLength < 0) {
            return false;
        }
        this.bufferPosition = 0;
        return this.bufferPosition < this.bufferLength;
    }
}

