/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FiltersFunctionScoreQuery
extends Query {
    Query subQuery;
    final FilterFunction[] filterFunctions;
    final ScoreMode scoreMode;
    DocSet[] docSets;

    public FiltersFunctionScoreQuery(Query subQuery, ScoreMode scoreMode, FilterFunction[] filterFunctions) {
        this.subQuery = subQuery;
        this.scoreMode = scoreMode;
        this.filterFunctions = filterFunctions;
        this.docSets = new DocSet[filterFunctions.length];
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public FilterFunction[] getFilterFunctions() {
        return this.filterFunctions;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FiltersFunctionScoreQuery bq = (FiltersFunctionScoreQuery)((Object)this.clone());
        bq.subQuery = newQ;
        return bq;
    }

    public void extractTerms(Set<Term> terms) {
        this.subQuery.extractTerms(terms);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new CustomBoostFactorWeight(searcher);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("custom score (").append(this.subQuery.toString(field)).append(", functions: [");
        for (FilterFunction filterFunction : this.filterFunctions) {
            sb.append("{filter(").append(filterFunction.filter).append("), function [").append(filterFunction.function).append("]}");
        }
        sb.append("])");
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FiltersFunctionScoreQuery other = (FiltersFunctionScoreQuery)((Object)o);
        if (this.getBoost() != other.getBoost()) {
            return false;
        }
        if (!this.subQuery.equals((Object)other.subQuery)) {
            return false;
        }
        return Arrays.equals(this.filterFunctions, other.filterFunctions);
    }

    public int hashCode() {
        return this.subQuery.hashCode() + 31 * Arrays.hashCode(this.filterFunctions) ^ Float.floatToIntBits(this.getBoost());
    }

    static class CustomBoostFactorScorer
    extends Scorer {
        private final float subQueryWeight;
        private final Scorer scorer;
        private final FilterFunction[] filterFunctions;
        private final ScoreMode scoreMode;
        private final DocSet[] docSets;

        private CustomBoostFactorScorer(Similarity similarity, CustomBoostFactorWeight w, Scorer scorer, ScoreMode scoreMode, FilterFunction[] filterFunctions, DocSet[] docSets) throws IOException {
            super(similarity);
            this.subQueryWeight = w.getValue();
            this.scorer = scorer;
            this.scoreMode = scoreMode;
            this.filterFunctions = filterFunctions;
            this.docSets = docSets;
        }

        public int docID() {
            return this.scorer.docID();
        }

        public int advance(int target) throws IOException {
            return this.scorer.advance(target);
        }

        public int nextDoc() throws IOException {
            return this.scorer.nextDoc();
        }

        public float score() throws IOException {
            int docId = this.scorer.docID();
            float score = this.scorer.score();
            if (this.scoreMode == ScoreMode.First) {
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    return this.subQueryWeight * this.filterFunctions[i].function.score(docId, score);
                }
            } else if (this.scoreMode == ScoreMode.Max) {
                float maxScore = Float.NEGATIVE_INFINITY;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    maxScore = Math.max(this.filterFunctions[i].function.score(docId, score), maxScore);
                }
                if (maxScore != Float.NEGATIVE_INFINITY) {
                    score = maxScore;
                }
            } else {
                float totalScore = 0.0f;
                int count = 0;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    totalScore += this.filterFunctions[i].function.score(docId, score);
                    ++count;
                }
                if (count != 0) {
                    score = totalScore;
                    if (this.scoreMode == ScoreMode.Avg) {
                        score /= (float)count;
                    }
                }
            }
            return this.subQueryWeight * score;
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        Searcher searcher;
        Weight subQueryWeight;

        public CustomBoostFactorWeight(Searcher searcher) throws IOException {
            this.searcher = searcher;
            this.subQueryWeight = FiltersFunctionScoreQuery.this.subQuery.weight(searcher);
        }

        public Query getQuery() {
            return FiltersFunctionScoreQuery.this;
        }

        public float getValue() {
            return FiltersFunctionScoreQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float sum = this.subQueryWeight.sumOfSquaredWeights();
            return sum *= FiltersFunctionScoreQuery.this.getBoost() * FiltersFunctionScoreQuery.this.getBoost();
        }

        public void normalize(float norm) {
            this.subQueryWeight.normalize(norm *= FiltersFunctionScoreQuery.this.getBoost());
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(reader, scoreDocsInOrder, false);
            if (subQueryScorer == null) {
                return null;
            }
            for (int i = 0; i < FiltersFunctionScoreQuery.this.filterFunctions.length; ++i) {
                FilterFunction filterFunction = FiltersFunctionScoreQuery.this.filterFunctions[i];
                filterFunction.function.setNextReader(reader);
                FiltersFunctionScoreQuery.this.docSets[i] = DocSets.convert(reader, filterFunction.filter.getDocIdSet(reader));
            }
            return new CustomBoostFactorScorer(FiltersFunctionScoreQuery.this.getSimilarity(this.searcher), this, subQueryScorer, FiltersFunctionScoreQuery.this.scoreMode, FiltersFunctionScoreQuery.this.filterFunctions, FiltersFunctionScoreQuery.this.docSets);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(reader, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            if (FiltersFunctionScoreQuery.this.scoreMode == ScoreMode.First) {
                for (FilterFunction filterFunction : FiltersFunctionScoreQuery.this.filterFunctions) {
                    DocSet docSet = DocSets.convert(reader, filterFunction.filter.getDocIdSet(reader));
                    if (!docSet.get(doc)) continue;
                    filterFunction.function.setNextReader(reader);
                    Explanation functionExplanation = filterFunction.function.explain(doc, subQueryExpl);
                    float sc = this.getValue() * functionExplanation.getValue();
                    ComplexExplanation complexExplanation = new ComplexExplanation(true, sc, "custom score, product of:");
                    complexExplanation.addDetail(new Explanation(1.0f, "match filter: " + filterFunction.filter.toString()));
                    complexExplanation.addDetail(functionExplanation);
                    complexExplanation.addDetail(new Explanation(this.getValue(), "queryBoost"));
                    return complexExplanation;
                }
            } else {
                int count = 0;
                float total = 0.0f;
                float max = Float.NEGATIVE_INFINITY;
                ArrayList<ComplexExplanation> filtersExplanations = new ArrayList<ComplexExplanation>();
                for (FilterFunction filterFunction : FiltersFunctionScoreQuery.this.filterFunctions) {
                    DocSet docSet = DocSets.convert(reader, filterFunction.filter.getDocIdSet(reader));
                    if (!docSet.get(doc)) continue;
                    filterFunction.function.setNextReader(reader);
                    Explanation functionExplanation = filterFunction.function.explain(doc, subQueryExpl);
                    float sc = functionExplanation.getValue();
                    ++count;
                    total += sc;
                    max = Math.max(sc, max);
                    ComplexExplanation res = new ComplexExplanation(true, sc, "custom score, product of:");
                    res.addDetail(new Explanation(1.0f, "match filter: " + filterFunction.filter.toString()));
                    res.addDetail(functionExplanation);
                    res.addDetail(new Explanation(this.getValue(), "queryBoost"));
                    filtersExplanations.add(res);
                }
                if (count > 0) {
                    float sc = 0.0f;
                    switch (FiltersFunctionScoreQuery.this.scoreMode) {
                        case Avg: {
                            sc = total / (float)count;
                            break;
                        }
                        case Max: {
                            sc = max;
                            break;
                        }
                        case Total: {
                            sc = total;
                        }
                    }
                    ComplexExplanation res = new ComplexExplanation(true, sc *= this.getValue(), "custom score, score mode [" + FiltersFunctionScoreQuery.this.scoreMode.toString().toLowerCase() + "]");
                    for (Explanation explanation : filtersExplanations) {
                        res.addDetail(explanation);
                    }
                    return res;
                }
            }
            float sc = this.getValue() * subQueryExpl.getValue();
            ComplexExplanation res = new ComplexExplanation(true, sc, "custom score, no filter match, product of:");
            res.addDetail(subQueryExpl);
            res.addDetail(new Explanation(this.getValue(), "queryBoost"));
            return res;
        }
    }

    public static enum ScoreMode {
        First,
        Avg,
        Max,
        Total;

    }

    public static class FilterFunction {
        public final Filter filter;
        public final ScoreFunction function;

        public FilterFunction(Filter filter, ScoreFunction function) {
            this.filter = filter;
            this.function = function;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterFunction that = (FilterFunction)o;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            return !(this.function != null ? !this.function.equals(that.function) : that.function != null);
        }

        public int hashCode() {
            int result = this.filter != null ? this.filter.hashCode() : 0;
            result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
            return result;
        }
    }
}

