/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.oio;

import java.util.concurrent.Executor;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelSink;
import org.elasticsearch.common.netty.channel.socket.ServerSocketChannel;
import org.elasticsearch.common.netty.channel.socket.ServerSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.oio.OioServerSocketChannel;
import org.elasticsearch.common.netty.channel.socket.oio.OioServerSocketPipelineSink;
import org.elasticsearch.common.netty.util.internal.ExecutorUtil;

public class OioServerSocketChannelFactory
implements ServerSocketChannelFactory {
    final Executor bossExecutor;
    private final Executor workerExecutor;
    private final ChannelSink sink;

    public OioServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.bossExecutor = bossExecutor;
        this.workerExecutor = workerExecutor;
        this.sink = new OioServerSocketPipelineSink(workerExecutor);
    }

    public ServerSocketChannel newChannel(ChannelPipeline pipeline) {
        return new OioServerSocketChannel(this, pipeline, this.sink);
    }

    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.bossExecutor, this.workerExecutor);
    }
}

