/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.oio;

import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.regex.Pattern;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.socket.oio.OioSocketChannel;

class OioWorker
implements Runnable {
    private static final Pattern SOCKET_CLOSED_MESSAGE = Pattern.compile("^.*(?:Socket.*closed).*$", 2);
    private final OioSocketChannel channel;

    OioWorker(OioSocketChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.channel.workerThread = Thread.currentThread();
        PushbackInputStream in = this.channel.getInputStream();
        while (this.channel.isOpen()) {
            int readBytes;
            byte[] buf;
            block10: {
                Object object = this.channel.interestOpsLock;
                synchronized (object) {
                    while (!this.channel.isReadable()) {
                        try {
                            this.channel.interestOpsLock.wait();
                        }
                        catch (InterruptedException e) {
                            if (this.channel.isOpen()) continue;
                            break;
                        }
                    }
                }
                try {
                    int bytesToRead = in.available();
                    if (bytesToRead > 0) {
                        buf = new byte[bytesToRead];
                        readBytes = in.read(buf);
                        break block10;
                    }
                    int b = in.read();
                    if (b < 0) break;
                    in.unread(b);
                    continue;
                }
                catch (Throwable t) {
                    if (this.channel.socket.isClosed()) break;
                    Channels.fireExceptionCaught(this.channel, t);
                    break;
                }
            }
            Channels.fireMessageReceived(this.channel, (Object)this.channel.getConfig().getBufferFactory().getBuffer(buf, 0, readBytes));
        }
        this.channel.workerThread = null;
        OioWorker.close(this.channel, Channels.succeededFuture(this.channel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(OioSocketChannel channel, ChannelFuture future, Object message) {
        OutputStream out = channel.getOutputStream();
        if (out == null) {
            ClosedChannelException e = new ClosedChannelException();
            future.setFailure(e);
            Channels.fireExceptionCaught(channel, (Throwable)e);
            return;
        }
        try {
            ChannelBuffer a = (ChannelBuffer)message;
            int length = a.readableBytes();
            OutputStream outputStream = out;
            synchronized (outputStream) {
                a.getBytes(a.readerIndex(), out, length);
            }
            Channels.fireWriteComplete(channel, (long)length);
            future.setSuccess();
        }
        catch (Throwable t2) {
            ClosedChannelException t2;
            if (t2 instanceof SocketException && SOCKET_CLOSED_MESSAGE.matcher(String.valueOf(t2.getMessage())).matches()) {
                t2 = new ClosedChannelException();
            }
            future.setFailure(t2);
            Channels.fireExceptionCaught(channel, (Throwable)t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInterestOps(OioSocketChannel channel, ChannelFuture future, int interestOps) {
        block9: {
            interestOps &= 0xFFFFFFFB;
            interestOps |= channel.getInterestOps() & 4;
            boolean changed = false;
            try {
                if (channel.getInterestOps() != interestOps) {
                    if ((interestOps & 1) != 0) {
                        channel.setInterestOpsNow(1);
                    } else {
                        channel.setInterestOpsNow(0);
                    }
                    changed = true;
                }
                future.setSuccess();
                if (!changed) break block9;
                Object object = channel.interestOpsLock;
                synchronized (object) {
                    channel.setInterestOpsNow(interestOps);
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                }
                Channels.fireChannelInterestChanged(channel);
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
            }
        }
    }

    static void close(OioSocketChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                    Channels.fireChannelDisconnected(channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }
}

