/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.smile.SmileXContent;

public class XContentFactory {
    private static int GUESS_HEADER_LENGTH = 20;
    private static final XContent[] contents = new XContent[2];

    public static XContentBuilder jsonBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.JSON);
    }

    public static XContentBuilder jsonBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(JsonXContent.jsonXContent, os);
    }

    public static XContentBuilder safeJsonBuilder() throws IOException {
        return XContentFactory.unCachedContentBuilder(XContentType.JSON);
    }

    public static XContentBuilder smileBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.SMILE);
    }

    public static XContentBuilder smileBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(SmileXContent.smileXContent, os);
    }

    public static XContentBuilder safeSmileBuilder() throws IOException {
        return XContentFactory.unCachedContentBuilder(XContentType.SMILE);
    }

    public static XContentBuilder contentBuilder(XContentType type, OutputStream outputStream) throws IOException {
        if (type == XContentType.JSON) {
            return XContentFactory.jsonBuilder(outputStream);
        }
        if (type == XContentType.SMILE) {
            return XContentFactory.smileBuilder(outputStream);
        }
        throw new ElasticSearchIllegalArgumentException("No matching content type for " + (Object)((Object)type));
    }

    public static XContentBuilder contentBuilder(XContentType type) throws IOException {
        if (type == XContentType.JSON) {
            return JsonXContent.contentBuilder();
        }
        if (type == XContentType.SMILE) {
            return SmileXContent.contentBuilder();
        }
        throw new ElasticSearchIllegalArgumentException("No matching content type for " + (Object)((Object)type));
    }

    public static XContentBuilder unCachedContentBuilder(XContentType type) throws IOException {
        if (type == XContentType.JSON) {
            return JsonXContent.unCachedContentBuilder();
        }
        if (type == XContentType.SMILE) {
            return SmileXContent.unCachedContentBuilder();
        }
        throw new ElasticSearchIllegalArgumentException("No matching content type for " + (Object)((Object)type));
    }

    public static XContent xContent(XContentType type) {
        return contents[type.index()];
    }

    public static XContentType xContentType(CharSequence content) {
        int length = content.length() < GUESS_HEADER_LENGTH ? content.length() : GUESS_HEADER_LENGTH;
        for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            if (c != '{') continue;
            return XContentType.JSON;
        }
        return null;
    }

    public static XContent xContent(CharSequence content) {
        XContentType type = XContentFactory.xContentType(content);
        if (type == null) {
            throw new ElasticSearchParseException("Failed to derive xcontent from " + content);
        }
        return XContentFactory.xContent(type);
    }

    public static XContent xContent(byte[] data) {
        return XContentFactory.xContent(data, 0, data.length);
    }

    public static XContent xContent(byte[] data, int offset, int length) {
        XContentType type = XContentFactory.xContentType(data, offset, length);
        if (type == null) {
            throw new ElasticSearchParseException("Failed to derive xcontent from (offset=" + offset + ", length=" + length + "): " + Arrays.toString(data));
        }
        return XContentFactory.xContent(type);
    }

    public static XContentType xContentType(byte[] data) {
        return XContentFactory.xContentType(data, 0, data.length);
    }

    public static XContentType xContentType(InputStream si) throws IOException {
        int third;
        int first = si.read();
        if (first == -1) {
            return null;
        }
        int second = si.read();
        if (second == -1) {
            return null;
        }
        if (first == 58 && second == 41 && (third = si.read()) == 10) {
            return XContentType.SMILE;
        }
        if (first == 123 || second == 123) {
            return XContentType.JSON;
        }
        for (int i = 2; i < GUESS_HEADER_LENGTH; ++i) {
            int val = si.read();
            if (val == -1) {
                return null;
            }
            if (val != 123) continue;
            return XContentType.JSON;
        }
        return null;
    }

    public static XContentType xContentType(byte[] data, int offset, int length) {
        int n = length = length < GUESS_HEADER_LENGTH ? length : GUESS_HEADER_LENGTH;
        if (length > 2 && data[offset] == 58 && data[offset + 1] == 41 && data[offset + 2] == 10) {
            return XContentType.SMILE;
        }
        int size = offset + length;
        for (int i = offset; i < size; ++i) {
            if (data[i] != 123) continue;
            return XContentType.JSON;
        }
        return null;
    }

    static {
        XContentFactory.contents[0] = JsonXContent.jsonXContent;
        XContentFactory.contents[1] = SmileXContent.smileXContent;
    }
}

