/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;

public class LocalGatewayStartedShards {
    private final long version;
    private final ImmutableMap<ShardId, Long> shards;

    public LocalGatewayStartedShards(long version, Map<ShardId, Long> shards) {
        this.version = version;
        this.shards = ImmutableMap.copyOf(shards);
    }

    public long version() {
        return this.version;
    }

    public ImmutableMap<ShardId, Long> shards() {
        return this.shards;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long version;
        private Map<ShardId, Long> shards = Maps.newHashMap();

        public Builder state(LocalGatewayStartedShards state) {
            this.version = state.version();
            this.shards.putAll(state.shards);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public boolean remove(ShardId shardId) {
            return this.shards.remove(shardId) != null;
        }

        public boolean put(ShardId shardId, long version) {
            Long lVersion = this.shards.get(shardId);
            if (lVersion != null && lVersion == version) {
                return false;
            }
            this.shards.put(shardId, version);
            return true;
        }

        public LocalGatewayStartedShards build() {
            return new LocalGatewayStartedShards(this.version, this.shards);
        }

        public static void toXContent(LocalGatewayStartedShards state, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("state");
            builder.field("version", state.version());
            builder.startArray("shards");
            for (Map.Entry entry : state.shards.entrySet()) {
                builder.startObject();
                builder.field("index", ((ShardId)entry.getKey()).index().name());
                builder.field("id", ((ShardId)entry.getKey()).id());
                builder.field("version", (Long)entry.getValue());
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
        }

        public static LocalGatewayStartedShards fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                return builder.build();
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!"shards".equals(currentFieldName)) continue;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token != XContentParser.Token.START_OBJECT) continue;
                        String shardIndex = null;
                        int shardId = -1;
                        long version = -1L;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("index".equals(currentFieldName)) {
                                shardIndex = parser.text();
                                continue;
                            }
                            if ("id".equals(currentFieldName)) {
                                shardId = parser.intValue();
                                continue;
                            }
                            if (!"version".equals(currentFieldName)) continue;
                            version = parser.longValue();
                        }
                        builder.shards.put(new ShardId(shardIndex, shardId), version);
                    }
                    continue;
                }
                if (!token.isValue() || !"version".equals(currentFieldName)) continue;
                builder.version = parser.longValue();
            }
            return builder.build();
        }

        public static LocalGatewayStartedShards readFrom(StreamInput in) throws IOException {
            Builder builder = new Builder();
            builder.version = in.readLong();
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                builder.shards.put(ShardId.readShardId(in), in.readLong());
            }
            return builder.build();
        }

        public static void writeTo(LocalGatewayStartedShards state, StreamOutput out) throws IOException {
            out.writeLong(state.version());
            out.writeVInt(state.shards.size());
            for (Map.Entry entry : state.shards.entrySet()) {
                ((ShardId)entry.getKey()).writeTo(out);
                out.writeLong((Long)entry.getValue());
            }
        }
    }

    public static class StartedShard {
        private final long version;
        private final ShardId shardId;

        public StartedShard(long version, ShardId shardId) {
            this.version = version;
            this.shardId = shardId;
        }

        public long version() {
            return this.version;
        }

        public ShardId shardId() {
            return this.shardId;
        }
    }
}

