/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class SnowballAnalyzerProvider
extends AbstractIndexAnalyzerProvider<SnowballAnalyzer> {
    private static final ImmutableMap<String, Set<?>> defaultLanguageStopwords = MapBuilder.newMapBuilder().put("English", StopAnalyzer.ENGLISH_STOP_WORDS_SET).put("Dutch", DutchAnalyzer.getDefaultStopSet()).put("German", GermanAnalyzer.getDefaultStopSet()).put("German2", GermanAnalyzer.getDefaultStopSet()).put("French", FrenchAnalyzer.getDefaultStopSet()).immutableMap();
    private final SnowballAnalyzer analyzer;

    @Inject
    public SnowballAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        String language = settings.get("language", settings.get("name", "English"));
        ImmutableSet defaultStopwords = defaultLanguageStopwords.containsKey(language) ? defaultLanguageStopwords.get(language) : ImmutableSet.of();
        Set<?> stopWords = Analysis.parseStopWords(env, settings, defaultStopwords);
        this.analyzer = new SnowballAnalyzer(this.version, language, stopWords);
    }

    @Override
    public SnowballAnalyzer get() {
        return this.analyzer;
    }
}

