/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.support;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.lab.LongsLAB;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.search.NoCacheFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.cache.filter.support.FilterCacheValue;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractConcurrentMapFilterCache
extends AbstractIndexComponent
implements FilterCache,
IndexReader.ReaderFinishedListener {
    final ConcurrentMap<Object, FilterCacheValue<ConcurrentMap<Object, DocSet>>> cache = this.buildCache();
    final boolean labEnabled = this.componentSettings.getAsBoolean("lab", false);
    final ByteSizeValue labMaxAlloc = this.componentSettings.getAsBytesSize("lab.max_alloc", new ByteSizeValue(128L, ByteSizeUnit.KB));
    final ByteSizeValue labChunkSize = this.componentSettings.getAsBytesSize("lab.chunk_size", new ByteSizeValue(1L, ByteSizeUnit.MB));
    final int labMaxAllocBytes = (int)(this.labMaxAlloc.bytes() / 8L);
    final int labChunkSizeBytes = (int)(this.labChunkSize.bytes() / 8L);

    protected AbstractConcurrentMapFilterCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    protected ConcurrentMap<Object, FilterCacheValue<ConcurrentMap<Object, DocSet>>> buildCache() {
        return new ConcurrentHashMap<Object, FilterCacheValue<ConcurrentMap<Object, DocSet>>>();
    }

    protected ConcurrentMap<Object, DocSet> buildFilterMap() {
        return ConcurrentCollections.newConcurrentMap();
    }

    @Override
    public void close() {
        this.cache.clear();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public void finished(IndexReader reader) {
        FilterCacheValue readerValue = (FilterCacheValue)this.cache.remove(reader.getCoreCacheKey());
        if (readerValue != null) {
            ((ConcurrentMap)readerValue.value()).clear();
        }
    }

    @Override
    public void clear(IndexReader reader) {
        FilterCacheValue readerValue = (FilterCacheValue)this.cache.remove(reader.getCoreCacheKey());
        if (readerValue != null) {
            ((ConcurrentMap)readerValue.value()).clear();
        }
    }

    @Override
    public FilterCache.EntriesStats entriesStats() {
        long sizeInBytes = 0L;
        long totalCount = 0L;
        int segmentsCount = 0;
        for (FilterCacheValue readerValue : this.cache.values()) {
            ++segmentsCount;
            for (DocSet docSet : ((ConcurrentMap)readerValue.value()).values()) {
                sizeInBytes += docSet.sizeInBytes();
                ++totalCount;
            }
        }
        return new FilterCache.EntriesStats(sizeInBytes, segmentsCount == 0 ? 0L : totalCount / (long)segmentsCount);
    }

    @Override
    public Filter cache(Filter filterToCache) {
        if (filterToCache instanceof NoCacheFilter) {
            return filterToCache;
        }
        if (this.isCached(filterToCache)) {
            return filterToCache;
        }
        return new FilterCacheFilterWrapper(filterToCache, this);
    }

    @Override
    public boolean isCached(Filter filter) {
        return filter instanceof FilterCacheFilterWrapper;
    }

    static class FilterCacheFilterWrapper
    extends Filter {
        private final Filter filter;
        private final AbstractConcurrentMapFilterCache cache;

        FilterCacheFilterWrapper(Filter filter, AbstractConcurrentMapFilterCache cache) {
            this.filter = filter;
            this.cache = cache;
        }

        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            DocSet docSet;
            FilterCacheValue<ConcurrentMap<Object, DocSet>> cacheValue = (FilterCacheValue<ConcurrentMap<Object, DocSet>>)this.cache.cache.get(reader.getCoreCacheKey());
            if (cacheValue == null) {
                LongsLAB longsLAB = null;
                if (this.cache.labEnabled) {
                    longsLAB = new LongsLAB(this.cache.labChunkSizeBytes, this.cache.labMaxAllocBytes);
                }
                cacheValue = new FilterCacheValue<ConcurrentMap<Object, DocSet>>(this.cache.buildFilterMap(), longsLAB);
                FilterCacheValue<ConcurrentMap<Object, DocSet>> prev = this.cache.cache.putIfAbsent(reader.getCoreCacheKey(), cacheValue);
                if (prev != null) {
                    cacheValue = prev;
                } else {
                    reader.addReaderFinishedListener((IndexReader.ReaderFinishedListener)this.cache);
                }
            }
            Object key = this.filter;
            if (this.filter instanceof CacheKeyFilter) {
                key = ((CacheKeyFilter)this.filter).cacheKey();
            }
            if ((docSet = (DocSet)((Object)((ConcurrentMap)cacheValue.value()).get(key))) != null) {
                return docSet;
            }
            DocIdSet docIdSet = this.filter.getDocIdSet(reader);
            docSet = FilterCacheValue.cacheable(reader, cacheValue.longsLAB(), docIdSet);
            DocSet prev = cacheValue.value().putIfAbsent(key, docSet);
            if (prev != null) {
                docSet = prev;
            }
            return docSet == DocSet.EMPTY_DOC_SET ? null : docSet;
        }

        public String toString() {
            return "FilterCacheFilterWrapper(" + this.filter + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof FilterCacheFilterWrapper)) {
                return false;
            }
            return this.filter.equals(((FilterCacheFilterWrapper)((Object)o)).filter);
        }

        public int hashCode() {
            return this.filter.hashCode() ^ 0x1117BF25;
        }
    }
}

