/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.BytesWrap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.ExtTObjectIntHasMap;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.cache.id.IdReaderCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderCache;
import org.elasticsearch.index.cache.id.simple.SimpleIdReaderTypeCache;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.settings.IndexSettings;

public class SimpleIdCache
extends AbstractIndexComponent
implements IdCache,
IndexReader.ReaderFinishedListener {
    private final ConcurrentMap<Object, SimpleIdReaderCache> idReaders = ConcurrentCollections.newConcurrentMap();

    @Inject
    public SimpleIdCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    @Override
    public void close() throws ElasticSearchException {
        this.clear();
    }

    @Override
    public void clear() {
        this.idReaders.clear();
    }

    public void finished(IndexReader reader) {
        this.clear(reader);
    }

    @Override
    public void clear(IndexReader reader) {
        this.idReaders.remove(reader.getCoreCacheKey());
    }

    @Override
    public IdReaderCache reader(IndexReader reader) {
        return (IdReaderCache)this.idReaders.get(reader.getCoreCacheKey());
    }

    @Override
    public Iterator<IdReaderCache> iterator() {
        return (Iterator)((Object)this.idReaders.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(IndexReader[] readers) throws Exception {
        if (this.refreshNeeded(readers)) {
            ConcurrentMap<Object, SimpleIdReaderCache> concurrentMap = this.idReaders;
            synchronized (concurrentMap) {
                BytesWrap idAsBytes;
                TypeBuilder typeBuilder;
                Uid uid;
                Term term;
                TermEnum termEnum;
                TermDocs termDocs;
                String field;
                Map<String, TypeBuilder> readerBuilder;
                if (!this.refreshNeeded(readers)) {
                    return;
                }
                HashMap<Object, Map<String, TypeBuilder>> builders = new HashMap<Object, Map<String, TypeBuilder>>();
                block9: for (IndexReader reader : readers) {
                    if (this.idReaders.containsKey(reader.getCoreCacheKey())) continue;
                    reader.addReaderFinishedListener((IndexReader.ReaderFinishedListener)this);
                    readerBuilder = new HashMap();
                    builders.put(reader.getCoreCacheKey(), readerBuilder);
                    field = StringHelper.intern((String)"_uid");
                    termDocs = reader.termDocs();
                    termEnum = reader.terms(new Term(field));
                    try {
                        while ((term = termEnum.term()) != null) {
                            if (term.field() != field) {
                                continue block9;
                            }
                            uid = Uid.createUid(term.text());
                            typeBuilder = (TypeBuilder)((HashMap)readerBuilder).get(uid.type());
                            if (typeBuilder == null) {
                                typeBuilder = new TypeBuilder(reader);
                                ((HashMap)readerBuilder).put(StringHelper.intern((String)uid.type()), typeBuilder);
                            }
                            idAsBytes = this.checkIfCanReuse(builders, new BytesWrap(uid.id()));
                            termDocs.seek(termEnum);
                            while (termDocs.next()) {
                                if (reader.isDeleted(termDocs.doc())) continue;
                                typeBuilder.idToDoc.put(idAsBytes, termDocs.doc());
                            }
                            if (termEnum.next()) continue;
                            continue block9;
                        }
                    }
                    finally {
                        termDocs.close();
                        termEnum.close();
                    }
                }
                block12: for (IndexReader reader : readers) {
                    if (this.idReaders.containsKey(reader.getCoreCacheKey())) continue;
                    readerBuilder = (Map)builders.get(reader.getCoreCacheKey());
                    field = StringHelper.intern((String)"_parent");
                    termDocs = reader.termDocs();
                    termEnum = reader.terms(new Term(field));
                    try {
                        while ((term = termEnum.term()) != null) {
                            if (term.field() != field) {
                                continue block12;
                            }
                            uid = Uid.createUid(term.text());
                            typeBuilder = (TypeBuilder)readerBuilder.get(uid.type());
                            if (typeBuilder == null) {
                                typeBuilder = new TypeBuilder(reader);
                                readerBuilder.put(StringHelper.intern((String)uid.type()), typeBuilder);
                            }
                            idAsBytes = this.checkIfCanReuse(builders, new BytesWrap(uid.id()));
                            boolean added = false;
                            termDocs.seek(termEnum);
                            while (termDocs.next()) {
                                if (reader.isDeleted(termDocs.doc())) continue;
                                if (!added) {
                                    typeBuilder.parentIdsValues.add(idAsBytes);
                                    added = true;
                                }
                                typeBuilder.parentIdsOrdinals[termDocs.doc()] = typeBuilder.t;
                            }
                            if (added) {
                                ++typeBuilder.t;
                            }
                            if (termEnum.next()) continue;
                            continue block12;
                        }
                    }
                    finally {
                        termDocs.close();
                        termEnum.close();
                    }
                }
                for (Map.Entry entry : builders.entrySet()) {
                    MapBuilder types = MapBuilder.newMapBuilder();
                    for (Map.Entry typeBuilderEntry : ((Map)entry.getValue()).entrySet()) {
                        types.put(typeBuilderEntry.getKey(), new SimpleIdReaderTypeCache((String)typeBuilderEntry.getKey(), ((TypeBuilder)typeBuilderEntry.getValue()).idToDoc, ((TypeBuilder)typeBuilderEntry.getValue()).parentIdsValues.toArray(new BytesWrap[((TypeBuilder)typeBuilderEntry.getValue()).parentIdsValues.size()]), ((TypeBuilder)typeBuilderEntry.getValue()).parentIdsOrdinals));
                    }
                    SimpleIdReaderCache readerCache = new SimpleIdReaderCache(entry.getKey(), types.immutableMap());
                    this.idReaders.put(readerCache.readerCacheKey(), readerCache);
                }
            }
        }
    }

    private BytesWrap checkIfCanReuse(Map<Object, Map<String, TypeBuilder>> builders, BytesWrap idAsBytes) {
        BytesWrap finalIdAsBytes;
        for (SimpleIdReaderCache simpleIdReaderCache : this.idReaders.values()) {
            finalIdAsBytes = simpleIdReaderCache.canReuse(idAsBytes);
            if (finalIdAsBytes == null) continue;
            return finalIdAsBytes;
        }
        for (Map map : builders.values()) {
            for (TypeBuilder typeBuilder : map.values()) {
                finalIdAsBytes = typeBuilder.canReuse(idAsBytes);
                if (finalIdAsBytes == null) continue;
                return finalIdAsBytes;
            }
        }
        return idAsBytes;
    }

    private boolean refreshNeeded(IndexReader[] readers) {
        for (IndexReader reader : readers) {
            if (this.idReaders.containsKey(reader.getCoreCacheKey())) continue;
            return true;
        }
        return false;
    }

    static class TypeBuilder {
        final ExtTObjectIntHasMap<BytesWrap> idToDoc = new ExtTObjectIntHasMap(10, 0.5f, -1);
        final ArrayList<BytesWrap> parentIdsValues = new ArrayList();
        final int[] parentIdsOrdinals;
        int t = 1;

        TypeBuilder(IndexReader reader) {
            this.parentIdsOrdinals = new int[reader.maxDoc()];
            this.parentIdsValues.add(null);
        }

        public BytesWrap canReuse(BytesWrap id) {
            return this.idToDoc.key(id);
        }
    }
}

