/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.bytes;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.bytes.ByteFieldData;
import org.elasticsearch.index.field.data.bytes.ByteFieldDataComparator;
import org.elasticsearch.index.field.data.bytes.ByteFieldDataMissingComparator;

public class ByteFieldDataType
implements FieldDataType<ByteFieldData> {
    @Override
    public FieldDataType.ExtendedFieldComparatorSource newFieldComparatorSource(final FieldDataCache cache, final String missing) {
        if (missing == null) {
            return new FieldDataType.ExtendedFieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new ByteFieldDataComparator(numHits, fieldname, cache);
                }

                @Override
                public int reducedType() {
                    return 10;
                }
            };
        }
        if (missing.equals("_last")) {
            return new FieldDataType.ExtendedFieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new ByteFieldDataMissingComparator(numHits, fieldname, cache, reversed ? (byte)-128 : 127);
                }

                @Override
                public int reducedType() {
                    return 10;
                }
            };
        }
        if (missing.equals("_first")) {
            return new FieldDataType.ExtendedFieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new ByteFieldDataMissingComparator(numHits, fieldname, cache, reversed ? (byte)127 : -128);
                }

                @Override
                public int reducedType() {
                    return 10;
                }
            };
        }
        return new FieldDataType.ExtendedFieldComparatorSource(){

            public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                return new ByteFieldDataMissingComparator(numHits, fieldname, cache, Byte.parseByte(missing));
            }

            @Override
            public int reducedType() {
                return 10;
            }
        };
    }

    @Override
    public ByteFieldData load(IndexReader reader, String fieldName) throws IOException {
        return ByteFieldData.load(reader, fieldName);
    }
}

