/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.shorts;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.shorts.ShortFieldData;
import org.elasticsearch.index.field.data.shorts.ShortFieldDataComparator;
import org.elasticsearch.index.field.data.shorts.ShortFieldDataMissingComparator;

public class ShortFieldDataType
implements FieldDataType<ShortFieldData> {
    @Override
    public FieldDataType.ExtendedFieldComparatorSource newFieldComparatorSource(final FieldDataCache cache, final String missing) {
        if (missing == null) {
            return new FieldDataType.ExtendedFieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new ShortFieldDataComparator(numHits, fieldname, cache);
                }

                @Override
                public int reducedType() {
                    return 8;
                }
            };
        }
        if (missing.equals("_last")) {
            return new FieldDataType.ExtendedFieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new ShortFieldDataMissingComparator(numHits, fieldname, cache, reversed ? (short)Short.MIN_VALUE : Short.MAX_VALUE);
                }

                @Override
                public int reducedType() {
                    return 8;
                }
            };
        }
        if (missing.equals("_first")) {
            return new FieldDataType.ExtendedFieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new ShortFieldDataMissingComparator(numHits, fieldname, cache, reversed ? (short)Short.MAX_VALUE : Short.MIN_VALUE);
                }

                @Override
                public int reducedType() {
                    return 8;
                }
            };
        }
        return new FieldDataType.ExtendedFieldComparatorSource(){

            public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                return new ShortFieldDataMissingComparator(numHits, fieldname, cache, Short.parseShort(missing));
            }

            @Override
            public int reducedType() {
                return 8;
            }
        };
    }

    @Override
    public ShortFieldData load(IndexReader reader, String fieldName) throws IOException {
        return ShortFieldData.load(reader, fieldName);
    }
}

