/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.strings;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.strings.StringFieldData;

public class MultiValueStringFieldData
extends StringFieldData {
    private static final int VALUE_CACHE_SIZE = 100;
    private static ThreadLocal<ThreadLocals.CleanableValue<String[][]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<String[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<String[][]> initialValue() {
            String[][] value = new String[100][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new String[i];
            }
            return new ThreadLocals.CleanableValue<String[][]>(value);
        }
    };
    private final int[][] ordinals;

    public MultiValueStringFieldData(String fieldName, int[][] ordinals, String[] values) {
        super(fieldName, values);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size = super.computeSizeInBytes();
        size += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc.onValue(docId, this.values[loc]);
        }
        if (!found) {
            proc.onMissing(docId);
        }
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc.onOrdinal(docId, ordinal[docId]);
        }
        if (!found) {
            proc.onOrdinal(docId, 0);
        }
    }

    @Override
    public String value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.values[loc];
        }
        return null;
    }

    @Override
    public String[] values(int docId) {
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length;
        }
        if (length == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] strings = length < 100 ? valuesCache.get().get()[length] : new String[length];
        int i = 0;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            strings[i++] = this.values[loc];
        }
        return strings;
    }
}

